/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.hordeevent.data.HordeScriptLoader;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;

public class HordeEventHandler {
    @SubscribeEvent
    public void addResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)HordeTableLoader.INSTANCE);
        event.addListener((PreparableReloadListener)HordeScriptLoader.INSTANCE);
    }

    @SubscribeEvent
    public void serverTick(ServerTickEvent.Pre event) {
        HordeSavedData data;
        if (((Boolean)HordeEventConfig.hordesCommandOnly.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel level = server.overworld();
        if (((Boolean)HordeEventConfig.pauseEventServer.get()).booleanValue() && level.players().isEmpty()) {
            return;
        }
        int day = (int)Math.floor((double)level.getDayTime() / (double)((Integer)HordeEventConfig.dayLength.get()).intValue());
        if (day < (data = HordeSavedData.getData(level)).getNextDay()) {
            return;
        }
        data.setNextDay(level.random.nextInt((Integer)HordeEventConfig.hordeSpawnVariation.get() + 1) + (Integer)HordeEventConfig.hordeSpawnDays.get() + data.getNextDay());
        data.save();
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        ServerPlayer player;
        block9: {
            block8: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block8;
                player = (ServerPlayer)player2;
                if (!(event.getEntity() instanceof FakePlayer)) break block9;
            }
            return;
        }
        ServerLevel level = player.serverLevel();
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        HordeEvent horde = HordeSavedData.getData(level).getEvent(player);
        if (horde == null) {
            return;
        }
        int time = Math.round(level.getDayTime() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        int day = horde.getCurrentDay(player);
        if (!horde.hasSynced(day)) {
            horde.sync(player, day);
        }
        if (horde.isActive(player)) {
            horde.update(player);
            return;
        }
        if (time >= (Integer)HordeEventConfig.hordeStartTime.get() && time <= (Integer)HordeEventConfig.hordeStartTime.get() + (Integer)HordeEventConfig.hordeStartBuffer.get() && day >= horde.getNextDay() && day > 0 || ((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue() && day == 0) {
            horde.tryStartEvent(player, -1, false);
        }
    }

    @SubscribeEvent
    public void logIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        HordeEvent horde = HordeSavedData.getData(player2.serverLevel()).getEvent(player2);
        if (horde != null) {
            horde.setPlayer(player2);
        }
    }

    @SubscribeEvent
    public void tryDespawn(MobDespawnEvent event) {
        ServerPlayer player = HordeSpawn.getHordePlayer((Entity)event.getEntity());
        if (player == null) {
            return;
        }
        HordeEvent horde = HordeSavedData.getData((ServerLevel)player.level()).getEvent(player);
        if (horde != null && horde.isActive(player)) {
            event.setResult(MobDespawnEvent.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void update(EntityTickEvent.Pre event) {
        HordeEvent horde;
        ServerPlayer player = HordeSpawn.getHordePlayer(event.getEntity());
        if (player == null | !(event.getEntity() instanceof Mob)) {
            return;
        }
        HordeSpawn cap = (HordeSpawn)event.getEntity().getCapability(HordesCapabilities.HORDESPAWN);
        if (cap == null) {
            return;
        }
        if (cap.isSynced()) {
            return;
        }
        Mob entity = (Mob)event.getEntity();
        entity.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        if (entity instanceof PathfinderMob) {
            entity.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
        }
        if (!(entity instanceof ZombifiedPiglin) || !((Boolean)CommonConfigHandler.aggressiveZombiePiglins.get()).booleanValue()) {
            entity.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
        }
        if ((horde = HordeSavedData.getData((ServerLevel)player.level()).getEvent(player)) != null && horde.isActive(player)) {
            horde.registerEntity(entity, player);
        }
        cap.setSynced();
    }

    @SubscribeEvent
    public void trySleep(CanPlayerSleepEvent event) {
        if (((Boolean)HordeEventConfig.canSleepDuringHorde.get()).booleanValue() || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = event.getEntity();
        ServerLevel level = player.serverLevel();
        HordeSavedData data = HordeSavedData.getData((ServerLevel)player.level());
        if (level.isDay() | (!level.dimensionType().bedWorks() || !data.isHordeNight(player))) {
            return;
        }
        event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        player.displayClientMessage((Component)Component.translatable((String)"message.hordes.TrySleep"), true);
    }
}

