/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.hordeevent.HordeSpawnType;
import net.smileycorp.hordes.hordeevent.HordeSpawnTypes;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;

public class HordeSpawnData {
    private HordeSpawnTable table = HordeTableLoader.INSTANCE.getFallbackTable();
    private HordeSpawnType spawnType = HordeSpawnTypes.AVOID_FLUIDS;
    private ResourceLocation spawnSound = Constants.HORDE_SOUND;
    private String startMessage = "message.hordes.EventStart";
    private String endMessage = "message.hordes.EventEnd";
    private int spawnDuration = (Integer)HordeEventConfig.hordeSpawnDuration.get();
    private int spawnInterval = (Integer)HordeEventConfig.hordeSpawnInterval.get();
    private int spawnAmount;
    private List<String> commands = Lists.newArrayList();
    private double entitySpeed = (Double)HordeEventConfig.hordeEntitySpeed.get();

    public HordeSpawnData(HordeEvent horde) {
        this.spawnAmount = (int)((double)((Integer)HordeEventConfig.hordeSpawnAmount.get()).intValue() * (1.0 + (double)(horde.getDay() / (Integer)HordeEventConfig.hordeSpawnDays.get()) * ((Double)HordeEventConfig.hordeSpawnMultiplier.get() - 1.0)));
    }

    public HordeSpawnData(HordeEvent horde, CompoundTag tag) {
        this(horde);
        if (tag.contains("table")) {
            this.table = HordeTableLoader.INSTANCE.getTable(ResourceLocation.tryParse((String)tag.getString("table")));
        }
        if (tag.contains("spawnType")) {
            this.spawnType = HordeSpawnTypes.fromNBT(tag.get("spawnType"));
        }
        if (tag.contains("spawnSound")) {
            this.spawnSound = ResourceLocation.tryParse((String)tag.getString("spawnSound"));
        }
        if (tag.contains("startMessage")) {
            this.startMessage = tag.getString("startMessage");
        }
        if (tag.contains("endMessage")) {
            this.endMessage = tag.getString("endMessage");
        }
        if (tag.contains("spawnDuration")) {
            this.spawnDuration = tag.getInt("spawnDuration");
        }
        if (tag.contains("spawnInterval")) {
            this.spawnInterval = tag.getInt("spawnInterval");
        }
        if (tag.contains("spawnAmount")) {
            this.spawnAmount = tag.getInt("spawnAmount");
        }
        if (tag.contains("entitySpeed")) {
            this.entitySpeed = tag.getDouble("entitySpeed");
        }
        if (tag.contains("commands")) {
            for (Tag command : tag.getList("commands", 8)) {
                this.commands.add(command.getAsString());
            }
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.table != null) {
            tag.putString("table", this.table.getName().toString());
        }
        if (this.spawnType != null) {
            tag.put("spawnType", HordeSpawnTypes.toNbt(this.spawnType));
        }
        if (this.spawnSound != null) {
            tag.putString("spawnSound", this.spawnSound.toString());
        }
        if (this.startMessage != null) {
            tag.putString("startMessage", this.startMessage);
        }
        if (this.endMessage != null) {
            tag.putString("endMessage", this.endMessage);
        }
        tag.putInt("spawnDuration", this.spawnDuration);
        tag.putInt("spawnInterval", this.spawnInterval);
        tag.putInt("spawnAmount", this.spawnAmount);
        tag.putDouble("entitySpeed", this.entitySpeed);
        if (!this.commands.isEmpty()) {
            ListTag commands = new ListTag();
            for (String command : this.commands) {
                commands.add((Object)StringTag.valueOf((String)command));
            }
            tag.put("commands", (Tag)commands);
        }
        return tag;
    }

    public HordeSpawnTable getTable() {
        return this.table;
    }

    public void setTable(HordeSpawnTable table) {
        this.table = table;
    }

    public HordeSpawnType getSpawnType() {
        return this.spawnType;
    }

    public void setSpawnType(HordeSpawnType spawnType) {
        this.spawnType = spawnType;
    }

    public ResourceLocation getSpawnSound() {
        return this.spawnSound;
    }

    public void setSpawnSound(ResourceLocation spawnSound) {
        this.spawnSound = spawnSound;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public void setEndMessage(String endMessage) {
        this.endMessage = endMessage;
    }

    public int getSpawnDuration() {
        return this.spawnDuration;
    }

    public void setSpawnDuration(int spawnDuration) {
        this.spawnDuration = spawnDuration;
    }

    public int getSpawnInterval() {
        return this.spawnInterval;
    }

    public void setSpawnInterval(int spawnInterval) {
        this.spawnInterval = spawnInterval;
    }

    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    public double getEntitySpeed() {
        return this.entitySpeed;
    }

    public void setEntitySpeed(double entitySpeed) {
        this.entitySpeed = entitySpeed;
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public Collection<String> getCommands() {
        return Lists.newArrayList(this.commands);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "[");
        builder.append("table=" + String.valueOf(this.table.getName()) + ", ");
        builder.append("spawnType=" + HordeSpawnTypes.toString(this.spawnType) + ", ");
        builder.append("spawnSound=" + String.valueOf(this.spawnSound) + ", ");
        builder.append("startMessage=" + this.startMessage + ", ");
        builder.append("endMessage=" + this.endMessage + ", ");
        builder.append("spawnDuration=" + this.spawnDuration + ", ");
        builder.append("spawnInterval=" + this.spawnInterval + ", ");
        builder.append("spawnAmount=" + this.spawnAmount + ", ");
        builder.append("entitySpeed=" + this.entitySpeed + "]");
        return builder.toString();
    }
}

