/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.network.GenericStringMessage;
import net.smileycorp.atlas.api.util.VecMath;
import net.smileycorp.atlas.api.util.WeightedOutputs;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.ai.HordeTrackPlayerGoal;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.event.HordeBuildSpawnDataEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordeFindSpawnPosEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.HordeSpawnData;
import net.smileycorp.hordes.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.hordeevent.data.HordeScriptLoader;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;
import net.smileycorp.hordes.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.hordeevent.network.HordeSoundMessage;
import net.smileycorp.hordes.hordeevent.network.UpdateClientHordeMessage;

public class HordeEvent {
    private final HordeSavedData data;
    private static final ResourceLocation FOLLOW_RANGE_MODIFIER = Constants.loc("horde_range");
    private RandomSource rand;
    private final Set<Mob> entitiesSpawned = Sets.newHashSet();
    private int timer = 0;
    private int day = 0;
    private int nextDay = -1;
    private HordeSpawnData spawnData = null;
    int sentDay = 0;
    private String username;

    HordeEvent(HordeSavedData data) {
        this.data = data;
        this.nextDay = ((Boolean)HordeEventConfig.hordeEventByPlayerTime.get()).booleanValue() ? (((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue() ? 0 : (Integer)HordeEventConfig.hordeSpawnDays.get()) : data.getNextDay();
    }

    public void readFromNBT(CompoundTag nbt) {
        this.entitiesSpawned.clear();
        if (nbt.contains("timer")) {
            this.timer = nbt.getInt("timer");
        }
        if (nbt.contains("nextDay")) {
            this.nextDay = nbt.getInt("nextDay");
        }
        if (nbt.contains("day")) {
            this.day = nbt.getInt("day");
        }
        if (nbt.contains("spawnData")) {
            this.spawnData = new HordeSpawnData(this, nbt.getCompound("spawnData"));
        }
        if (!nbt.contains("loadedTable")) {
            return;
        }
        this.spawnData = new HordeSpawnData(this);
        this.spawnData.setTable(HordeTableLoader.INSTANCE.getTable(ResourceLocation.tryParse((String)nbt.getString("loadedTable"))));
    }

    public CompoundTag writeToNBT(CompoundTag nbt, UUID uuid) {
        ServerPlayer player;
        nbt.putInt("timer", this.timer);
        nbt.putInt("nextDay", this.nextDay);
        nbt.putInt("day", this.day);
        if (this.spawnData != null) {
            nbt.put("spawnData", (Tag)this.spawnData.save());
        }
        nbt.putString("username", (player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid)) == null ? (this.username == null ? uuid.toString() : this.username) : player.getName().getString());
        return nbt;
    }

    public void update(ServerPlayer player) {
        Level level = player.level();
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        if (this.spawnData == null) {
            return;
        }
        if (this.timer % this.spawnData.getSpawnInterval() == 0) {
            this.spawnWave(player, this.getMobCount(player, level));
        }
        --this.timer;
        if (this.timer == 0) {
            this.stopEvent(player, false);
        }
    }

    private int getMobCount(ServerPlayer player, Level level) {
        int amount = this.spawnData.getSpawnAmount();
        List players = level.players();
        for (Player other : players) {
            if (!this.shouldReduce(player, (ServerPlayer)other)) continue;
            amount = (int)Math.floor((double)amount * (Double)HordeEventConfig.hordeMultiplayerScaling.get());
        }
        return amount;
    }

    private boolean shouldReduce(ServerPlayer player, ServerPlayer other) {
        if (other == player || player.distanceTo((Entity)other) > 25.0f) {
            return false;
        }
        HordeEvent horde = this.data.getEvent(other);
        return horde != null && horde.isActive(other);
    }

    public void spawnWave(ServerPlayer player, int count) {
        WeightedOutputs<HordeSpawnEntry> spawntable;
        RandomSource rand = this.getRandom();
        this.cleanSpawns();
        if (this.spawnData == null) {
            this.rand = null;
            rand = this.getRandom();
            HordeBuildSpawnDataEvent buildTableEvent = new HordeBuildSpawnDataEvent(player, this);
            this.postEvent(buildTableEvent);
            this.spawnData = buildTableEvent.getSpawnData();
        }
        if (this.spawnData == null || this.spawnData.getTable() == null) {
            this.logError("Cannot load wave spawn data, cancelling spawns.", new Exception());
            return;
        }
        ServerLevel level = player.serverLevel();
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(player, this, count);
        this.postEvent(startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vec3 basedir = VecMath.randomXZVec((RandomSource)rand);
        BlockPos basepos = VecMath.closestLoadedPos((Level)level, (BlockPos)player.blockPosition(), (Vec3)basedir, (double)50.0, (int)7, (int)0);
        int i = 0;
        while (basepos.equals((Object)player.blockPosition())) {
            basedir = VecMath.randomXZVec((RandomSource)rand);
            basepos = this.getBasePos(level, basedir, player, true);
            if (!this.spawnData.getSpawnType().canSpawn(level, basepos)) {
                basepos = player.blockPosition();
            }
            if (i++ < (Integer)HordeEventConfig.hordeSpawnChecks.get()) continue;
            this.logInfo("Unable to find unlit pos for horde " + String.valueOf(this) + " ignoring light level");
            basedir = VecMath.randomXZVec((RandomSource)rand);
            basepos = this.getBasePos(level, basedir, player, false);
            break;
        }
        if ((spawntable = this.spawnData.getTable().getSpawnTable(this.day)).isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count <= 0) {
            this.logInfo("Stopping wave spawn because count is " + count);
            return;
        }
        HordeEventPacketHandler.sendTo((CustomPacketPayload)new HordeSoundMessage((float)basedir.x, (float)basedir.z, this.spawnData.getSpawnSound()), player);
        for (HordeSpawnEntry entry : spawntable.getResults(rand, count)) {
            if (this.entitiesSpawned.size() > (Integer)HordeEventConfig.hordeSpawnMax.get()) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vec3 pos = this.getSpawnPos(level, basepos.getCenter());
            EntityType<?> type = entry.getEntity();
            try {
                AtomicBoolean cancelled = new AtomicBoolean(false);
                CompoundTag nbt = entry.getNBT();
                nbt.putString("id", entry.getName().toString());
                Mob mob = (Mob)EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)level, entity -> this.loadEntity(level, player, (Mob)entity, pos, cancelled));
                if (cancelled.get()) continue;
                mob.readAdditionalSaveData(entry.getNBT());
                if (!level.tryAddFreshEntityWithPassengers((Entity)mob)) {
                    this.logError("Unable to spawn entity from " + String.valueOf(type), new Exception());
                    continue;
                }
                this.finalizeEntity(mob, player, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError("Unable to spawn entity from " + String.valueOf(type), e);
            }
        }
    }

    private BlockPos getBasePos(ServerLevel level, Vec3 basedir, ServerPlayer player, boolean checkLight) {
        double radius = (Double)HordeEventConfig.hordeSpawnDistance.get();
        BlockPos pos = checkLight ? VecMath.closestLoadedPos((Level)level, (BlockPos)player.blockPosition(), (Vec3)basedir, (double)radius, (int)7, (int)0) : VecMath.closestLoadedPos((Level)level, (BlockPos)player.blockPosition(), (Vec3)basedir, (double)radius);
        HordeFindSpawnPosEvent event = new HordeFindSpawnPosEvent(player, this, basedir, pos, checkLight);
        this.postEvent(event);
        return event.getPos();
    }

    private Vec3 getSpawnPos(ServerLevel level, Vec3 basepos) {
        for (int j = 0; j < 5; ++j) {
            double x = basepos.x() + (double)this.rand.nextInt(10);
            double z = basepos.z() + (double)this.rand.nextInt(10);
            Vec3 pos = new Vec3(x, (double)level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)x, (int)z), z);
            if (!this.spawnData.getSpawnType().canSpawn(level, BlockPos.containing((Position)pos))) continue;
            return pos;
        }
        return basepos;
    }

    private Entity loadEntity(ServerLevel level, ServerPlayer player, Mob entity, Vec3 pos, AtomicBoolean cancel) {
        HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(player, entity, pos, this);
        this.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCanceled()) {
            entity = spawnEntityEvent.getEntity();
            pos = spawnEntityEvent.getPos();
            entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(BlockPos.containing((Position)pos)), null, null);
            entity.setPos(pos.x(), pos.y(), pos.z());
            return entity;
        }
        this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + String.valueOf(entity.getType()));
        cancel.set(true);
        return entity;
    }

    private void finalizeEntity(Mob entity, ServerPlayer player, boolean addToMobCap) {
        entity.getAttribute(Attributes.FOLLOW_RANGE).addPermanentModifier(new AttributeModifier(FOLLOW_RANGE_MODIFIER, 75.0, AttributeModifier.Operation.ADD_VALUE));
        if (addToMobCap) {
            this.registerEntity(entity, player);
        }
        entity.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
        if (entity instanceof PathfinderMob) {
            entity.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
        }
        entity.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(entity, ServerPlayer.class, true));
        for (Entity passenger : entity.getPassengers()) {
            if (!(passenger instanceof Mob)) continue;
            this.finalizeEntity((Mob)passenger, player, false);
        }
    }

    private void cleanSpawns() {
        ArrayList<Mob> toRemove = new ArrayList<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            HordeSpawn cap;
            if (entity.isAlive() | !entity.isRemoved() || (cap = (HordeSpawn)entity.getCapability(HordesCapabilities.HORDESPAWN, null)) == null) continue;
            cap.setPlayerUUID("");
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    public boolean isHordeDay(ServerPlayer player) {
        ServerLevel level = player.serverLevel();
        if (level.dimension() != Level.OVERWORLD) {
            return false;
        }
        return this.isActive(player) || this.getCurrentDay(player) >= this.nextDay;
    }

    public boolean isActive(ServerPlayer player) {
        return this.timer > 0;
    }

    public void setPlayer(ServerPlayer player) {
        this.setNextDay(player);
        this.cleanSpawns();
        this.entitiesSpawned.forEach(entity -> this.fixGoals(player, (Mob)entity));
    }

    private void fixGoals(ServerPlayer player, Mob entity) {
        for (WrappedGoal entry : (WrappedGoal[])entity.goalSelector.getAvailableGoals().toArray(WrappedGoal[]::new)) {
            if (!(entry.getGoal() instanceof HordeTrackPlayerGoal)) continue;
            entity.goalSelector.removeGoal(entry.getGoal());
            entity.goalSelector.addGoal(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player, this.spawnData.getEntitySpeed()));
            return;
        }
    }

    public void tryStartEvent(ServerPlayer player, int duration, boolean isCommand) {
        this.cleanSpawns();
        if ((Boolean)HordeEventConfig.hordesCommandOnly.get() & !isCommand) {
            return;
        }
        if (!isCommand) {
            this.logInfo("Trying to start horde event on day " + this.getCurrentDay(player) + " with nextDay " + this.nextDay + " and time " + player.level().getDayTime() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        }
        if (player == null) {
            this.logError("player is null for " + String.valueOf(this), new NullPointerException());
            return;
        }
        ServerLevel level = player.serverLevel();
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        this.rand = this.data.getRandom(this.day);
        HordeStartEvent startEvent = new HordeStartEvent(player, this, isCommand);
        this.postEvent(startEvent);
        if (startEvent.isCanceled()) {
            this.spawnData = null;
            return;
        }
        if (this.spawnData == null) {
            HordeBuildSpawnDataEvent event = new HordeBuildSpawnDataEvent(player, this);
            this.postEvent(event);
            this.spawnData = event.getSpawnData();
        }
        if (this.spawnData == null || this.spawnData.getTable() == null || this.spawnData.getTable().getSpawnTable(this.day).isEmpty()) {
            this.spawnData = null;
            this.logInfo("Spawntable is empty, canceling event start.");
        } else {
            this.timer = duration <= 0 ? this.spawnData.getSpawnDuration() : duration;
            this.sendMessage(player, this.spawnData.getStartMessage());
            this.day = isCommand ? this.getCurrentDay(player) : this.nextDay;
        }
        if (!isCommand) {
            this.setNextDay(player);
        }
    }

    public void setSpawntable(HordeSpawnTable table) {
        if (table == null || table == HordeTableLoader.INSTANCE.getFallbackTable()) {
            this.spawnData = null;
            return;
        }
        if (this.spawnData == null) {
            this.spawnData = new HordeSpawnData(this);
        }
        this.spawnData.setTable(table);
    }

    public HordeSpawnTable getSpawnTable() {
        return this.spawnData == null ? null : this.spawnData.getTable();
    }

    public HordeSpawnData getSpawnData() {
        return this.spawnData;
    }

    public void setNextDay(int day) {
        this.nextDay = day;
    }

    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(ServerPlayer player, String str) {
        HordeEventPacketHandler.sendTo((CustomPacketPayload)new GenericStringMessage(str, HordeEventPacketHandler.NOTIFICATION), player);
    }

    public void stopEvent(ServerPlayer player, boolean isCommand) {
        this.entitiesSpawned.clear();
        HordeEndEvent endEvent = new HordeEndEvent(player, this, isCommand, this.spawnData.getEndMessage(), this.spawnData.getCommands());
        this.postEvent(endEvent);
        HordeEventPacketHandler.sendTo((CustomPacketPayload)new UpdateClientHordeMessage(false), player);
        this.sentDay = this.getCurrentDay(player);
        this.timer = 0;
        this.spawnData = null;
        this.sendMessage(player, endEvent.getMessage());
        MinecraftServer server = player.getServer();
        for (String command : endEvent.getCommands()) {
            server.getCommands().performPrefixedCommand(server.createCommandSourceStack().withSuppressedOutput().withPermission(2).withEntity((Entity)player).withPosition(player.position()).withLevel(player.serverLevel()), command);
        }
        for (Mob entity : this.entitiesSpawned) {
            HordeSpawn cap;
            for (WrappedGoal entry : (WrappedGoal[])entity.goalSelector.getAvailableGoals().toArray(WrappedGoal[]::new)) {
                if (!(entry.getGoal() instanceof HordeTrackPlayerGoal)) continue;
                entity.goalSelector.removeGoal(entry.getGoal());
                break;
            }
            if ((cap = (HordeSpawn)entity.getCapability(HordesCapabilities.HORDESPAWN)) != null) continue;
            cap.setPlayerUUID("");
            entity.getAttribute(Attributes.FOLLOW_RANGE).removeModifier(FOLLOW_RANGE_MODIFIER);
        }
        this.rand = null;
    }

    public void removeEntity(Mob entity) {
        this.entitiesSpawned.remove(entity);
    }

    public void registerEntity(Mob entity, ServerPlayer player) {
        HordeSpawn cap = (HordeSpawn)entity.getCapability(HordesCapabilities.HORDESPAWN);
        if (!this.isActive(player) || this.spawnData == null) {
            if (cap != null) {
                cap.setPlayerUUID("");
            }
            return;
        }
        if (cap != null) {
            cap.setPlayerUUID(player.getUUID().toString());
        }
        if (!this.entitiesSpawned.contains(entity)) {
            this.entitiesSpawned.add(entity);
        }
        entity.goalSelector.addGoal(6, (Goal)new HordeTrackPlayerGoal(entity, (Entity)player, this.spawnData.getEntitySpeed()));
    }

    private void postEvent(HordePlayerEvent event) {
        HordeScriptLoader.INSTANCE.applyScripts(event);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    public void reset(ServerPlayer player) {
        this.entitiesSpawned.clear();
        this.setNextDay(player);
        this.spawnData = null;
        this.timer = 0;
    }

    private void setNextDay(ServerPlayer player) {
        if (!((Boolean)HordeEventConfig.hordeEventByPlayerTime.get()).booleanValue()) {
            this.nextDay = this.data.getNextDay();
            return;
        }
        int expectedDay = (Integer)HordeEventConfig.hordeSpawnDays.get() * (this.getCurrentDay(player) / (Integer)HordeEventConfig.hordeSpawnDays.get() + 1);
        if (this.nextDay <= this.getCurrentDay(player) || Math.abs(this.nextDay - expectedDay) > (Integer)HordeEventConfig.hordeSpawnDays.get() + (Integer)HordeEventConfig.hordeSpawnVariation.get()) {
            if ((Integer)HordeEventConfig.hordeSpawnVariation.get() > 0) {
                expectedDay += this.getRandom().nextInt(((Integer)HordeEventConfig.hordeSpawnVariation.get()).intValue());
                this.rand = null;
            }
            this.nextDay = expectedDay;
        }
    }

    public boolean hasSynced(int day) {
        return this.sentDay >= day;
    }

    public void sync(ServerPlayer player, int day) {
        HordeEventPacketHandler.sendTo((CustomPacketPayload)new UpdateClientHordeMessage(this.isHordeDay(player)), player);
        this.sentDay = day;
    }

    public int getDay() {
        return this.day;
    }

    public int getCurrentDay(ServerPlayer player) {
        return (int)Math.floor(((Boolean)HordeEventConfig.hordeEventByPlayerTime.get() != false ? (long)player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME)) : player.level().getDayTime()) / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
    }

    private void logInfo(Object message) {
        HordesLogger.logInfo("[" + String.valueOf(this) + "]" + String.valueOf(message));
    }

    private void logError(Object message, Exception e) {
        HordesLogger.logError("[" + String.valueOf(this) + "]" + String.valueOf(message), e);
    }

    public String toString(String player) {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player = " + (player == null ? "null" : player) + ", isActive = " + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {" + (this.entitiesSpawned.isEmpty() ? "}" : ""));
        ArrayList<Mob> entitylist = new ArrayList<Mob>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (Mob entity : sublist) {
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(entity) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }

    public RandomSource getRandom() {
        if (this.rand == null) {
            this.rand = this.data.getRandom(this.day);
        }
        return this.rand;
    }
}

