/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;

public class HordeSavedData
extends SavedData {
    public static final String DATA = "hordes";
    private final RandomSource rand = RandomSource.create();
    private int next_day = 0;
    protected ServerLevel level = null;
    private Map<UUID, HordeEvent> events = Maps.newHashMap();

    public void load(CompoundTag nbt) {
        int next;
        if (nbt.contains("next_day") && (next = nbt.getInt("next_day")) > this.next_day) {
            this.next_day = next;
        }
        if (nbt.contains("events")) {
            CompoundTag events = nbt.getCompound("events");
            for (String uuid : events.getAllKeys()) {
                if (!DataUtils.isValidUUID((String)uuid)) {
                    return;
                }
                HordeEvent horde = new HordeEvent(this);
                horde.readFromNBT(events.getCompound(uuid));
                this.events.put(UUID.fromString(uuid), horde);
            }
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt("next_day", this.next_day);
        CompoundTag events = new CompoundTag();
        for (Map.Entry<UUID, HordeEvent> entry : this.events.entrySet()) {
            UUID uuid = entry.getKey();
            CompoundTag tag = new CompoundTag();
            events.put(uuid.toString(), (Tag)entry.getValue().writeToNBT(tag, uuid));
        }
        nbt.put("events", (Tag)events);
        return nbt;
    }

    public int getNextDay() {
        return this.next_day;
    }

    public void setNextDay(int next_day) {
        this.next_day = next_day;
    }

    public void save() {
        this.setDirty();
        if (this.level instanceof ServerLevel) {
            this.level.getChunkSource().getDataStorage().set(DATA, (SavedData)this);
        }
    }

    public HordeEvent getEvent(ServerPlayer player) {
        return player == null ? null : this.getEvent(player.getUUID());
    }

    public HordeEvent getEvent(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (!this.events.containsKey(uuid)) {
            this.events.put(uuid, new HordeEvent(this));
        }
        return this.events.get(uuid);
    }

    public String getName(UUID uuid) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(uuid);
        if (player != null) {
            return player.getName().getString();
        }
        Optional profile = ServerLifecycleHooks.getCurrentServer().getProfileCache().get(uuid);
        if (profile.isPresent() && ((GameProfile)profile.get()).getName() != null) {
            return ((GameProfile)profile.get()).getName();
        }
        return uuid.toString();
    }

    public boolean isHordeNight(ServerPlayer player) {
        if (((Boolean)HordeEventConfig.hordePreventsOtherPlayersSleeping.get()).booleanValue()) {
            for (Player player1 : this.level.players()) {
                HordeEvent horde = this.getEvent(player1.getUUID());
                if (!horde.isHordeDay(player)) continue;
                return true;
            }
            return false;
        }
        HordeEvent horde = this.getEvent(player);
        return horde != null && horde.isHordeDay(player);
    }

    public RandomSource getRandom(int day) {
        return RandomSource.create((long)(this.level.getSeed() % 32767L * (long)day));
    }

    public String toString() {
        return super.toString() + "[current_day: " + (int)Math.floor((float)this.level.getDayTime() / (float)((Integer)HordeEventConfig.dayLength.get()).intValue()) + ", current_time: " + this.level.getDayTime() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue() + ", next_day=" + this.next_day + "]";
    }

    public List<String> getDebugText() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.toString());
        out.add("Existing events: {");
        for (Map.Entry<UUID, HordeEvent> entry : this.events.entrySet()) {
            out.add("\t" + entry.getValue().toString(this.getName(entry.getKey())));
            out.addAll(entry.getValue().getEntityStrings());
        }
        out.add("}");
        return out;
    }

    public static HordeSavedData getData(ServerLevel level) {
        HordeSavedData data = (HordeSavedData)level.getChunkSource().getDataStorage().computeIfAbsent(new SavedData.Factory(() -> HordeSavedData.getCleanData(level), (nbt, provider) -> HordeSavedData.getDataFromNBT(level, nbt)), DATA);
        level.getChunkSource().getDataStorage().set(DATA, (SavedData)data);
        return data;
    }

    private static HordeSavedData getDataFromNBT(ServerLevel level, CompoundTag nbt) {
        HordeSavedData data = HordeSavedData.getCleanData(level);
        data.load(nbt);
        return data;
    }

    public static HordeSavedData getCleanData(ServerLevel level) {
        HordeSavedData data = new HordeSavedData();
        data.level = level;
        int day = Math.round(level.getDayTime() / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        double multiplier = Math.ceil(day / (Integer)HordeEventConfig.hordeSpawnDays.get());
        if (!((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue() || day != 0) {
            multiplier += 1.0;
        }
        int nextDay = (int)Math.floor(multiplier * (double)((Integer)HordeEventConfig.hordeSpawnDays.get()).intValue() + (double)level.random.nextInt((Integer)HordeEventConfig.hordeSpawnVariation.get() + 1));
        data.setNextDay(nextDay);
        return data;
    }
}

