/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import java.util.UUID;
import net.minecraft.nbt.StringTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.capability.HordesCapabilities;

public interface HordeSpawn {
    public boolean isHordeSpawned();

    public void setPlayerUUID(String var1);

    public String getPlayerUUID();

    public boolean isSynced();

    public void setSynced();

    public StringTag writeNBT();

    public void readNBT(StringTag var1);

    public static ServerPlayer getHordePlayer(Entity entity) {
        if (entity.level().isClientSide | !(entity instanceof Mob)) {
            return null;
        }
        HordeSpawn hordespawn = (HordeSpawn)entity.getCapability(HordesCapabilities.HORDESPAWN);
        if (hordespawn == null) {
            return null;
        }
        if (!hordespawn.isHordeSpawned()) {
            return null;
        }
        String uuid = hordespawn.getPlayerUUID();
        if (!DataUtils.isValidUUID((String)uuid)) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(UUID.fromString(uuid));
    }

    public static class Impl
    implements HordeSpawn {
        private String uuid = "";
        private boolean isSynced;

        @Override
        public boolean isHordeSpawned() {
            return !this.uuid.isEmpty();
        }

        @Override
        public void setPlayerUUID(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public String getPlayerUUID() {
            return this.uuid;
        }

        @Override
        public boolean isSynced() {
            return this.isSynced;
        }

        @Override
        public void setSynced() {
            this.isSynced = true;
        }

        @Override
        public StringTag writeNBT() {
            return StringTag.valueOf((String)this.uuid);
        }

        @Override
        public void readNBT(StringTag tag) {
            this.uuid = tag.getAsString();
        }
    }
}

