/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.hordeevent.HordeSpawnTable;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.data.HordeTableLoader;

public class CommandSpawnWave {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawnWave").requires(commandSource -> commandSource.hasPermission(1))).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), null))).then(Commands.argument((String)"table", (ArgumentType)ResourceLocationArgument.id()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"table")))))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), EntityArgument.getPlayers((CommandContext)ctx, (String)"player"), null))).then(Commands.argument((String)"table", (ArgumentType)ResourceLocationArgument.id()).suggests(HordeTableLoader::getSuggestions).executes(ctx -> CommandSpawnWave.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), EntityArgument.getPlayers((CommandContext)ctx, (String)"player"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"table")))))));
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count, ResourceLocation table) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.getEntity() instanceof ServerPlayer) {
            return CommandSpawnWave.execute(ctx, count, Lists.newArrayList((Object[])new ServerPlayer[]{source.getPlayerOrException()}), table);
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, int count, Collection<ServerPlayer> players, ResourceLocation table) throws CommandSyntaxException {
        for (ServerPlayer player : players) {
            HordeEvent horde = HordeSavedData.getData(((CommandSourceStack)ctx.getSource()).getLevel()).getEvent(player);
            try {
                HordeSpawnTable current = horde.getSpawnTable();
                horde.setSpawntable(HordeTableLoader.INSTANCE.getTable(table));
                horde.spawnWave(player, count);
                horde.setSpawntable(current);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to run startHordeEvent command", e);
            }
        }
        return 1;
    }
}

