/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.smileycorp.atlas.api.data.BinaryOperation;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.atlas.api.data.LogicalOperation;
import net.smileycorp.atlas.api.data.UnaryOperation;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordeBuildSpawnDataEvent;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.hordeevent.data.conditions.AdvancementCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.BiomeCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.ComparisonCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.hordeevent.data.conditions.DayCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.EntityTypeCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.GameDifficultyCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.GameStagesCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.LocalDifficultyCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.LogicalCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.NotCondition;
import net.smileycorp.hordes.hordeevent.data.conditions.RandomCondition;
import net.smileycorp.hordes.hordeevent.data.functions.HordeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.MultipleFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.AddRewardCommandFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetEndMessageFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetEntitySpeedFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnAmountFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnDurationFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnIntervalFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnSoundFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawnTypeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetSpawntableFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawndata.SetStartMessageFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityLootTableFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityNBTFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityTypeFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityXFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityYFunction;
import net.smileycorp.hordes.hordeevent.data.functions.spawnentity.SetEntityZFunction;
import net.smileycorp.hordes.hordeevent.data.values.BinaryOperationValueGetter;
import net.smileycorp.hordes.hordeevent.data.values.EntityNBTGetter;
import net.smileycorp.hordes.hordeevent.data.values.EntityPosGetter;
import net.smileycorp.hordes.hordeevent.data.values.EventDayGetter;
import net.smileycorp.hordes.hordeevent.data.values.LevelNBTGetter;
import net.smileycorp.hordes.hordeevent.data.values.PlayerNBTGetter;
import net.smileycorp.hordes.hordeevent.data.values.PlayerPosGetter;
import net.smileycorp.hordes.hordeevent.data.values.SpawnTableGetter;
import net.smileycorp.hordes.hordeevent.data.values.UnaryOperationValueGetter;
import net.smileycorp.hordes.hordeevent.data.values.ValueGetter;
import net.smileycorp.hordes.hordeevent.data.values.WeightedRandomValueGetter;

public class DataRegistry {
    private static Map<ResourceLocation, BiFunction<JsonObject, DataType, ValueGetter>> VALUE_GETTERS = Maps.newHashMap();
    private static Map<ResourceLocation, Function<JsonElement, Condition>> CONDITIONS = Maps.newHashMap();
    private static Map<ResourceLocation, Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>>> FUNCTIONS = Maps.newHashMap();

    public static void init() {
        DataRegistry.registerValueGetters();
        DataRegistry.registerConditionDeserializers();
        DataRegistry.registerFunctionSerializers();
    }

    private static void registerValueGetters() {
        UnaryOperation.values().forEach(operation -> DataRegistry.registerValueGetter(Constants.loc(operation.getName()), (obj, type) -> UnaryOperationValueGetter.deserialize(operation, type, obj)));
        BinaryOperation.values().forEach(operation -> DataRegistry.registerValueGetter(Constants.loc(operation.getName()), (obj, type) -> BinaryOperationValueGetter.deserialize(operation, type, obj)));
        DataRegistry.registerValueGetter(Constants.loc("weighted_random"), WeightedRandomValueGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("level_nbt"), LevelNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("player_nbt"), PlayerNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("player_pos"), PlayerPosGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("entity_nbt"), EntityNBTGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("entity_pos"), EntityPosGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("day"), EventDayGetter::deserialize);
        DataRegistry.registerValueGetter(Constants.loc("spawn_table"), SpawnTableGetter::deserialize);
    }

    public static void registerConditionDeserializers() {
        for (LogicalOperation operation : LogicalOperation.values()) {
            DataRegistry.registerConditionDeserializer(Constants.loc(operation.getName()), e -> LogicalCondition.deserialize(operation, e));
        }
        DataRegistry.registerConditionDeserializer(Constants.loc("not"), NotCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("comparison"), ComparisonCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("random"), RandomCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("biome"), BiomeCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("day"), DayCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("player_day"), DayCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("local_difficulty"), LocalDifficultyCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("game_difficulty"), GameDifficultyCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("advancement"), AdvancementCondition::deserialize);
        DataRegistry.registerConditionDeserializer(Constants.loc("entity_type"), EntityTypeCondition::deserialize);
        if (ModList.get().isLoaded("gamestages")) {
            DataRegistry.registerConditionDeserializer(ResourceLocation.tryParse((String)"gamestages:gamestage"), GameStagesCondition::deserialize);
        }
    }

    public static void registerFunctionSerializers() {
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawntable"), HordeBuildSpawnDataEvent.class, SetSpawntableFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_type"), HordeBuildSpawnDataEvent.class, SetSpawnTypeFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_sound"), HordeBuildSpawnDataEvent.class, SetSpawnSoundFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_start_message"), HordeBuildSpawnDataEvent.class, SetStartMessageFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_end_message"), HordeBuildSpawnDataEvent.class, SetEndMessageFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_duration"), HordeBuildSpawnDataEvent.class, SetSpawnDurationFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_interval"), HordeBuildSpawnDataEvent.class, SetSpawnIntervalFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_spawn_amount"), HordeBuildSpawnDataEvent.class, SetSpawnAmountFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_speed"), HordeBuildSpawnDataEvent.class, SetEntitySpeedFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("add_reward_command"), HordeBuildSpawnDataEvent.class, AddRewardCommandFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_type"), HordeSpawnEntityEvent.class, SetEntityTypeFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_nbt"), HordeSpawnEntityEvent.class, SetEntityNBTFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_x"), HordeSpawnEntityEvent.class, SetEntityXFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_y"), HordeSpawnEntityEvent.class, SetEntityYFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_z"), HordeSpawnEntityEvent.class, SetEntityZFunction::deserialize);
        DataRegistry.registerFunctionDeserializer(Constants.loc("set_entity_loot_table"), HordeSpawnEntityEvent.class, SetEntityLootTableFunction::deserialize);
    }

    public static ValueGetter readValue(DataType type, JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                ResourceLocation loc = ResourceLocation.tryParse((String)json.get("name").getAsString());
                BiFunction<JsonObject, DataType, ValueGetter> getter = VALUE_GETTERS.get(loc);
                if (getter == null) {
                    throw new NullPointerException("value getter " + String.valueOf(loc) + " is not registered");
                }
                return getter.apply(json, type);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read value " + String.valueOf(json), e);
            }
        }
        return null;
    }

    public static Condition readCondition(JsonObject json) {
        if (json.has("name") && json.has("value")) {
            try {
                ResourceLocation loc = ResourceLocation.tryParse((String)json.get("name").getAsString());
                Function<JsonElement, Condition> deserializer = CONDITIONS.get(loc);
                if (deserializer == null) {
                    throw new NullPointerException("condition " + String.valueOf(loc) + " is not registered");
                }
                return deserializer.apply(json.get("value"));
            }
            catch (Exception e) {
                HordesLogger.logError("Failed to read condition " + String.valueOf(json), e);
            }
        }
        return null;
    }

    public static <T extends HordePlayerEvent> Pair<Class<T>, HordeFunction<T>> readFunction(JsonObject json) {
        if (!json.has("function") || !json.has("value")) {
            return Pair.of(null, null);
        }
        if (json.get("function").getAsString().equals("hordes:multiple")) {
            return MultipleFunction.deserialize(json.get("value").getAsJsonArray());
        }
        try {
            ResourceLocation loc = ResourceLocation.tryParse((String)json.get("function").getAsString());
            Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>> pair = FUNCTIONS.get(loc);
            if (pair == null) {
                throw new NullPointerException("function " + String.valueOf(loc) + " is not registered");
            }
            return Pair.of((Object)((Class)pair.getFirst()), (Object)((HordeFunction)((Function)pair.getSecond()).apply(json.get("value"))));
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to read function " + String.valueOf(json), e);
            return Pair.of(null, null);
        }
    }

    public static void registerValueGetter(ResourceLocation name, BiFunction<JsonObject, DataType, ValueGetter> getter) {
        VALUE_GETTERS.put(name, getter);
    }

    public static void registerConditionDeserializer(ResourceLocation name, Function<JsonElement, Condition> serializer) {
        CONDITIONS.put(name, serializer);
    }

    public static <T extends HordePlayerEvent> void registerFunctionDeserializer(ResourceLocation name, Class<T> clazz, Function<JsonElement, HordeFunction<T>> serializer) {
        FUNCTIONS.put(name, (Pair<Class<? extends HordePlayerEvent>, Function<JsonElement, HordeFunction<? extends HordePlayerEvent>>>)new Pair(clazz, serializer));
    }

    public static CompoundTag parseNBT(String name, String nbtstring) {
        CompoundTag nbt = null;
        try {
            CompoundTag parsed = TagParser.parseTag((String)nbtstring);
            if (parsed == null) {
                throw new NullPointerException("Parsed NBT is null.");
            }
            nbt = parsed;
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to read config, " + String.valueOf(e.getCause()) + " " + e.getMessage(), e);
            HordesLogger.logError("Error parsing nbt for entity " + name + " " + e.getMessage(), e);
        }
        return nbt;
    }
}

