/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.conditions;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.conditions.Condition;

public class BiomeCondition
implements Condition {
    protected final List<Either<TagKey<Biome>, ResourceLocation>> biomes;

    public BiomeCondition(List<Either<TagKey<Biome>, ResourceLocation>> biomes) {
        this.biomes = biomes;
    }

    @Override
    public boolean apply(HordePlayerEvent event) {
        Holder biome = event.getLevel().getBiomeManager().getBiome(event.getEntity().blockPosition());
        for (Either<TagKey<Biome>, ResourceLocation> either : this.biomes) {
            if (!((Boolean)either.map(arg_0 -> ((Holder)biome).is(arg_0), arg_0 -> ((Holder)biome).is(arg_0))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static BiomeCondition deserialize(JsonElement json) {
        try {
            if (json.isJsonArray()) {
                ArrayList biomes = Lists.newArrayList();
                for (JsonElement element : json.getAsJsonArray()) {
                    biomes.add(BiomeCondition.either(element.getAsString()));
                }
                return new BiomeCondition(biomes);
            }
            return new BiomeCondition(Lists.newArrayList((Object[])new Either[]{BiomeCondition.either(json.getAsString())}));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:biome", e);
            return null;
        }
    }

    private static Either<TagKey<Biome>, ResourceLocation> either(String string) {
        return string.contains("#") ? Either.left((Object)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.tryParse((String)string.replace("#", "")))) : Either.right((Object)ResourceLocation.tryParse((String)string));
    }
}

