/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.conditions;

import com.google.gson.JsonElement;
import java.util.UUID;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.hordeevent.data.values.ValueGetter;

public class GameStagesCondition
implements Condition {
    protected ValueGetter<String> stage;

    public GameStagesCondition(ValueGetter<String> stage) {
        this.stage = stage;
    }

    @Override
    public boolean apply(HordePlayerEvent event) {
        return GameStageSaveHandler.getPlayerData((UUID)event.getPlayer().getUUID()).hasStage(this.stage.get(event));
    }

    public static GameStagesCondition deserialize(JsonElement json) {
        try {
            return new GameStagesCondition(ValueGetter.readValue(DataType.STRING, json));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition gamestages:gamestage", e);
            return null;
        }
    }
}

