/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.DataRegistry;
import net.smileycorp.hordes.hordeevent.data.conditions.Condition;
import net.smileycorp.hordes.hordeevent.data.functions.HordeFunction;

public class MultipleFunction<T extends HordePlayerEvent>
implements HordeFunction<T> {
    private final Class<T> clazz;
    private final List<Pair<List<Condition>, HordeFunction<T>>> functions;

    public MultipleFunction(Class<T> clazz, List<Pair<List<Condition>, HordeFunction<T>>> functions) {
        this.clazz = clazz;
        this.functions = functions;
    }

    @Override
    public void apply(T event) {
        if (event.getClass() != this.clazz) {
            return;
        }
        this.functions.forEach(pair -> this.tryApply((Pair<List<Condition>, HordeFunction<T>>)pair, event));
    }

    private void tryApply(Pair<List<Condition>, HordeFunction<T>> pair, T event) {
        for (Condition condition : (List)pair.getFirst()) {
            if (condition.apply((HordePlayerEvent)((Object)event))) continue;
            return;
        }
        ((HordeFunction)pair.getSecond()).apply(event);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.functions.size(); ++i) {
            builder.append(this.functions.get(i).toString());
            if (i >= this.functions.size() - 1) continue;
            builder.append(" && ");
        }
        return super.toString() + "[" + String.valueOf(builder) + "]";
    }

    public static <T extends HordePlayerEvent> Pair<Class<T>, HordeFunction<T>> deserialize(JsonArray json) {
        Class clazz = null;
        ArrayList functions = Lists.newArrayList();
        for (JsonElement element : json) {
            ArrayList conditions;
            JsonObject obj = element.getAsJsonObject();
            Pair pair = DataRegistry.readFunction(obj);
            if (clazz == null && pair.getFirst() != null) {
                conditions = Lists.newArrayList();
                if (obj.has("conditions")) {
                    obj.get("conditions").getAsJsonArray().forEach(condition -> conditions.add(DataRegistry.readCondition(condition.getAsJsonObject())));
                }
                clazz = (Class)pair.getFirst();
                functions.add(Pair.of((Object)conditions, (Object)((HordeFunction)pair.getSecond())));
                continue;
            }
            if (clazz != pair.getFirst()) continue;
            conditions = Lists.newArrayList();
            if (obj.has("conditions")) {
                obj.get("conditions").getAsJsonArray().forEach(condition -> conditions.add(DataRegistry.readCondition(condition.getAsJsonObject())));
            }
            functions.add(Pair.of((Object)conditions, (Object)((HordeFunction)pair.getSecond())));
        }
        return Pair.of(clazz, new MultipleFunction<T>(clazz, functions));
    }
}

