/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.NetworkMessage;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.hordeevent.client.HordeClientHandler;

public class HordeSoundMessage
implements NetworkMessage {
    public static CustomPacketPayload.Type<HordeSoundMessage> TYPE = new CustomPacketPayload.Type(Constants.loc("horde_sound"));
    protected float dirX;
    protected float dirZ;
    protected ResourceLocation sound;

    public HordeSoundMessage() {
    }

    public HordeSoundMessage(float dirX, float dirZ, ResourceLocation sound) {
        this.dirX = dirX;
        this.dirZ = dirZ;
        this.sound = sound;
    }

    public void read(FriendlyByteBuf buf) {
        this.dirX = buf.readFloat();
        this.dirZ = buf.readFloat();
        this.sound = ResourceLocation.tryParse((String)buf.readUtf());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.dirX);
        buf.writeFloat(this.dirZ);
        if (this.sound != null) {
            buf.writeUtf(this.sound.toString());
        }
    }

    public void process(IPayloadContext ctx) {
        if (ctx.connection().getDirection().isClientbound()) {
            ctx.enqueueWork(() -> HordeClientHandler.INSTANCE.playHordeSound(this.dirX, this.dirZ, this.sound));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

