/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.NetworkMessage;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.client.HordeClientHandler;

public class UpdateClientHordeMessage
implements NetworkMessage {
    public static CustomPacketPayload.Type<UpdateClientHordeMessage> TYPE = new CustomPacketPayload.Type(Constants.loc("sync_horde_client"));
    private boolean horde_day;
    private int day_length;

    public UpdateClientHordeMessage() {
    }

    public UpdateClientHordeMessage(boolean horde_day) {
        this.horde_day = horde_day;
        this.day_length = (Integer)HordeEventConfig.dayLength.get();
    }

    public void read(FriendlyByteBuf buf) {
        this.horde_day = buf.readBoolean();
        this.day_length = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.horde_day);
        buf.writeInt(this.day_length);
    }

    public void process(IPayloadContext ctx) {
        if (ctx.connection().getDirection().isClientbound()) {
            ctx.enqueueWork(() -> HordeClientHandler.INSTANCE.setHordeDay(this.horde_day, this.day_length));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

