/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.config.ClientConfigHandler;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.client.InfectionLayer;
import net.smileycorp.hordes.infection.data.InfectionData;
import net.smileycorp.hordes.infection.network.CureEntityMessage;

public class InfectionClientHandler {
    public static final InfectionClientHandler INSTANCE = new InfectionClientHandler();

    public void registerOverlays(RegisterGuiLayersEvent event) {
        if (!((Boolean)ClientConfigHandler.playerInfectionVisuals.get()).booleanValue()) {
            return;
        }
        event.registerBelowAll(Constants.loc("infection"), (LayeredDraw.Layer)new InfectionLayer());
    }

    @SubscribeEvent
    public void preRenderEntity(RenderLivingEvent.Pre event) {
        int a;
        LivingEntity entity = event.getEntity();
        LocalPlayer player = Minecraft.getInstance().player;
        if (!((Boolean)ClientConfigHandler.playerInfectionVisuals.get()).booleanValue()) {
            return;
        }
        if (player != null && player.hasEffect(HordesInfection.INFECTED) && entity != player) {
            a = player.getEffect(HordesInfection.INFECTED).getAmplifier();
            if (a > 2) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else if (a == 2) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else if (a == 1) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.7f, (float)0.7f, (float)1.0f);
            }
            if (a > 0) {
                return;
            }
        }
        if (entity.hasEffect(HordesInfection.INFECTED)) {
            a = entity.getEffect(HordesInfection.INFECTED).getAmplifier();
            RenderSystem.setShaderColor((float)((float)Math.pow(0.95f, a + 1)), (float)1.0f, (float)((float)Math.pow(0.8f, a + 1)), (float)1.0f);
        }
    }

    @SubscribeEvent
    public void postRenderEntity(RenderLivingEvent.Post event) {
        if (RenderSystem.getShaderColor().equals(new float[]{1.0f, 1.0f, 1.0f, 1.0f})) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tooltip(RenderTooltipEvent.GatherComponents event) {
        int immunity;
        ItemStack stack = event.getItemStack();
        ArrayList components = Lists.newArrayList();
        if (((Boolean)ClientConfigHandler.cureTooltip.get()).booleanValue() && stack.is(HordesInfection.INFECTION_CURES_TAG)) {
            components.add(Component.translatable((String)"tooltip.hordes.cure"));
        }
        if (((Boolean)ClientConfigHandler.immunityTooltip.get()).booleanValue() && (immunity = InfectionData.INSTANCE.getImmunityLength(stack)) > 0) {
            PotionContents.addPotionTooltip((Iterable)Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(HordesInfection.IMMUNITY, immunity * 20)}), components::add, (float)1.0f, (float)Minecraft.getInstance().level.tickRateManager().tickrate());
        }
        components.forEach(c -> event.getTooltipElements().add(Either.left((Object)c)));
    }

    @SubscribeEvent
    public void logOut(PlayerEvent.PlayerLoggedOutEvent event) {
        InfectionData.INSTANCE.clear();
    }

    public void onInfect(boolean prevented) {
        SoundEvent event;
        SoundEvent soundEvent = prevented && (Boolean)ClientConfigHandler.infectionProtectSound.get() != false ? Constants.IMMUNE_SOUND : (event = !prevented && (Boolean)ClientConfigHandler.playerInfectSound.get() != false ? Constants.INFECT_SOUND : null);
        if (event == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        player.level().playSound((Player)player, player.blockPosition(), event, SoundSource.PLAYERS, 0.75f, player.getRandom().nextFloat());
    }

    public void processCureEntity(CureEntityMessage message) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LivingEntity entity = message.getEntity((Level)level);
        level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, entity.getSoundSource(), 1.0f, 1.0f, true);
        RandomSource rand = level.random;
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, entity.getX() + (rand.nextDouble() - 0.5) * (double)entity.getBbWidth() * 1.5, entity.getY() + rand.nextDouble() * (double)entity.getBbHeight(), entity.getZ() + (rand.nextDouble() - 0.5) * (double)entity.getBbWidth() * 1.5, 0.0, 0.3, 0.0);
        }
    }
}

