/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.network;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.NetworkMessage;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.infection.data.InfectionData;

public class SyncImmunityItemsMessage
implements NetworkMessage {
    public static CustomPacketPayload.Type<SyncImmunityItemsMessage> TYPE = new CustomPacketPayload.Type(Constants.loc("sync_immunity_items"));
    private final List<Map.Entry<Item, Integer>> data = Lists.newArrayList();

    public SyncImmunityItemsMessage() {
    }

    public SyncImmunityItemsMessage(Map<Item, Integer> immunityItems) {
        this.data.addAll(immunityItems.entrySet());
    }

    public void read(FriendlyByteBuf buf) {
        while (buf.isReadable()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)buf.readUtf()));
            if (item == null) continue;
            this.data.add(new AbstractMap.SimpleEntry<Item, Integer>(item, buf.readInt()));
        }
    }

    public void write(FriendlyByteBuf buf) {
        this.data.forEach(e -> {
            buf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)((Item)e.getKey())).toString());
            buf.writeInt(((Integer)e.getValue()).intValue());
        });
    }

    public void process(IPayloadContext ctx) {
        if (ctx.connection().getDirection().isClientbound()) {
            ctx.enqueueWork(() -> InfectionData.INSTANCE.readImmunityItems(this.data));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

