/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.network;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.smileycorp.atlas.api.network.NetworkMessage;
import net.smileycorp.hordes.common.Constants;
import net.smileycorp.hordes.infection.data.InfectionData;

public class SyncWearableProtectionMessage
implements NetworkMessage {
    public static CustomPacketPayload.Type<SyncWearableProtectionMessage> TYPE = new CustomPacketPayload.Type(Constants.loc("sync_wearable_protection"));
    private final List<Pair<Item, Float>> data = Lists.newArrayList();

    public SyncWearableProtectionMessage() {
    }

    public SyncWearableProtectionMessage(Map<Item, Float> wearableProtection) {
        wearableProtection.forEach((item, chance) -> this.data.add((Pair<Item, Float>)Pair.of((Object)item, (Object)chance)));
    }

    public void read(FriendlyByteBuf buf) {
        while (buf.isReadable()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)buf.readUtf()));
            if (item == null) continue;
            this.data.add((Pair<Item, Float>)Pair.of((Object)item, (Object)Float.valueOf(buf.readFloat())));
        }
    }

    public void write(FriendlyByteBuf buf) {
        this.data.forEach(e -> {
            buf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)((Item)e.getFirst())).toString());
            buf.writeFloat(((Float)e.getSecond()).floatValue());
        });
    }

    public void process(IPayloadContext ctx) {
        if (ctx.connection().getDirection().isClientbound()) {
            ctx.enqueueWork(() -> InfectionData.INSTANCE.readWearableProtection(this.data));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

