/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.common.ai.HorseFleeGoal;
import net.smileycorp.hordes.config.CommonConfigHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class MixinAbstractHorse
extends Animal {
    @Shadow
    protected SimpleContainer inventory;

    protected MixinAbstractHorse(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep"}, cancellable=true)
    public void hordes$aiStep(CallbackInfo callback) {
        if (this instanceof ZombieHorse) {
            if (((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
                this.updateSwingTime();
                if (this.getLightLevelDependentMagicValue() > 0.5f) {
                    this.noActionTime += 2;
                }
            }
            if (((Boolean)CommonConfigHandler.zombieHorsesBurn.get()).booleanValue()) {
                this.tryBurn();
            }
        } else if (this instanceof SkeletonHorse && ((Boolean)CommonConfigHandler.skeletonHorsesBurn.get()).booleanValue()) {
            this.tryBurn();
        }
    }

    protected void tryBurn() {
        if (!this.isSunBurnTick() | !this.getPassengers().isEmpty()) {
            return;
        }
        ItemStack itemstack = this.inventory.getItem(1);
        if (itemstack.isEmpty()) {
            this.igniteForSeconds(8.0f);
            return;
        }
        if (itemstack.isDamageableItem()) {
            itemstack.setDamageValue(itemstack.getDamageValue() + this.random.nextInt(2));
            if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                this.inventory.setItem(1, ItemStack.EMPTY);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"registerGoals"}, cancellable=true)
    public void hordes$registerGoals(CallbackInfo callback) {
        if (this.getType().is(EntityTypeTags.UNDEAD) && ((Boolean)CommonConfigHandler.zombiesScareHorses.get()).booleanValue()) {
            this.goalSelector.addGoal(1, (Goal)new HorseFleeGoal((Mob)this));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canEatGrass"}, cancellable=true)
    public void hordes$canEatGrass(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)false);
        }
    }
}

