/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.common.mixinutils.ChatName;
import net.smileycorp.hordes.common.mixinutils.CustomTexture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements CustomTexture {
    private static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public MixinLivingEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.entityData.set(TEXTURE, (Object)texture.toString());
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryParse((String)((String)this.entityData.get(TEXTURE)));
    }

    @Override
    public boolean hasCustomTexture() {
        return !((String)this.entityData.get(TEXTURE)).isEmpty();
    }

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    public void hordes$defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo callback) {
        builder.define(TEXTURE, (Object)"");
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void hordes$addAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        if (this.hasCustomTexture()) {
            tag.putString("texture", (String)this.entityData.get(TEXTURE));
        }
        if (((ChatName)((Object)this)).hasChatName()) {
            tag.putString("chat_name", ((ChatName)((Object)this)).getChatName());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void hordes$readAdditionalSaveData(CompoundTag tag, CallbackInfo callback) {
        String texture;
        if (tag.contains("texture") && ResourceLocation.tryParse((String)(texture = tag.getString("texture"))) != null) {
            this.entityData.set(TEXTURE, (Object)texture);
        }
        if (tag.contains("chat_name")) {
            ((ChatName)((Object)this)).setChatName(tag.getString("chat_name"));
        }
    }
}

