/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.atlas.api.util.Func;
import net.smileycorp.hordes.common.ai.FleeEntityGoal;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.data.InfectionData;
import net.smileycorp.hordes.infection.network.CureEntityMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MixinMob
extends LivingEntity {
    @Shadow
    public GoalSelector goalSelector;

    public MixinMob(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions"}, cancellable=true)
    public void hordes$checkAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.hasEffect((Holder)HordesInfection.INFECTED)) {
            return;
        }
        if (!HordesInfection.isCure(stack)) {
            return;
        }
        this.removeEffect((Holder)HordesInfection.INFECTED);
        if (!player.level().isClientSide) {
            InfectionPacketHandler.sendTracking((CustomPacketPayload)new CureEntityMessage(this), (Entity)this);
        }
        if (!player.isCreative()) {
            ItemStack container = stack.getItem().getCraftingRemainingItem(stack);
            if (stack.isDamageableItem() && player instanceof ServerPlayer) {
                stack.hurtAndBreak(1, ((ServerPlayer)player).serverLevel(), (ServerPlayer)player, xva$0 -> Func.Void((Object[])new Object[]{xva$0}));
            } else {
                stack.shrink(1);
            }
            if (stack.isEmpty() && !container.isEmpty()) {
                player.setItemInHand(hand, container);
            }
        }
        callback.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
    }

    @Inject(at={@At(value="HEAD")}, method={"isSunBurnTick"}, cancellable=true)
    public void hordes$isSunBurnTick(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof AbstractSkeleton & (Boolean)CommonConfigHandler.skeletonsBurn.get() == false) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDespawnInPeaceful"}, cancellable=true)
    public void hordes$shouldDespawnInPeaceful(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"convertTo"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/Entity;")})
    private Entity hordes$convertTo(EntityType instance, Level level, Operation<Entity> original) {
        Entity entity = (Entity)original.call(new Object[]{instance, level});
        if (!(entity instanceof Mob)) {
            return entity;
        }
        Mob converted = (Mob)entity;
        HordeSpawn before = (HordeSpawn)this.getCapability(HordesCapabilities.HORDESPAWN);
        HordeSpawn after = (HordeSpawn)converted.getCapability(HordesCapabilities.HORDESPAWN);
        if (before == null || after == null) {
            return converted;
        }
        if (!before.isHordeSpawned()) {
            return converted;
        }
        String uuid = before.getPlayerUUID();
        if (!DataUtils.isValidUUID((String)uuid)) {
            return converted;
        }
        after.setPlayerUUID(uuid);
        before.setPlayerUUID("");
        HordeEvent horde = HordeSavedData.getData((ServerLevel)this.level()).getEvent(UUID.fromString(uuid));
        if (horde != null) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(UUID.fromString(uuid));
            horde.registerEntity(converted, player);
            horde.removeEntity((Mob)this);
            converted.targetSelector.getAvailableGoals().forEach(WrappedGoal::stop);
            if (converted instanceof PathfinderMob) {
                converted.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)converted, new Class[0]));
            }
            converted.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(converted, Player.class, true));
        }
        return converted;
    }

    @Inject(at={@At(value="TAIL")}, method={"convertTo"}, cancellable=true)
    public void hordes$convertTo(EntityType<?> type, boolean keepEquipment, CallbackInfoReturnable<Mob> callback) {
        Mob converted = (Mob)callback.getReturnValue();
        HordeSpawn cap = (HordeSpawn)converted.getCapability(HordesCapabilities.HORDESPAWN);
        if (cap == null) {
            return;
        }
        if (!cap.isHordeSpawned()) {
            return;
        }
        String uuid = cap.getPlayerUUID();
        if (DataUtils.isValidUUID((String)uuid)) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(UUID.fromString(uuid));
            if (player == null) {
                return;
            }
            HordeEvent horde = HordeSavedData.getData((ServerLevel)this.level()).getEvent(player);
            if (horde == null) {
                return;
            }
            if (!horde.isActive(player)) {
                return;
            }
            horde.registerEntity((Mob)this, player);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"registerGoals"}, cancellable=true)
    public void hordes$registerGoals(CallbackInfo callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && this instanceof Piglin) {
            this.goalSelector.addGoal(1, (Goal)new FleeEntityGoal((Mob)this, 1.5, 5.0, InfectionData.INSTANCE::canCauseInfection));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeLeashed"})
    public void hordes$canBeLeashed(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)false);
        }
    }
}

