/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Piglin.class})
public abstract class MixinPiglin
extends AbstractPiglin {
    @Shadow
    @Final
    private SimpleContainer inventory;

    @Shadow
    public abstract Brain<Piglin> getBrain();

    protected MixinPiglin(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"customServerAiStep"}, cancellable=true)
    public void hordes$customServerAiStep(CallbackInfo callback) {
        if (!((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue() || !((Boolean)CommonConfigHandler.piglinsCureThemself.get()).booleanValue()) {
            return;
        }
        if (!this.hasEffect((Holder)HordesInfection.INFECTED)) {
            return;
        }
        if (!this.getBrain().checkMemory(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_ABSENT)) {
            return;
        }
        if (!this.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
            return;
        }
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i).copy();
            if (!stack.is(HordesInfection.INFECTION_CURES_TAG)) continue;
            stack.setCount(1);
            this.inventory.getItem(i).shrink(1);
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
            this.startUsingItem(InteractionHand.OFF_HAND);
            return;
        }
    }
}

