/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import plus.dragons.visuality.particle.type.ColorParticleType;

public class SparkleParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    private SparkleParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.setColor(r, g, b);
        this.lifetime = 5 + this.random.nextInt(4);
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.scale(1.1f);
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public int getLightColor(float tint) {
        return 0xF000F0;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleType.Options>
    {
        public Particle createParticle(ColorParticleType.Options options, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new SparkleParticle(world, x, y, z, options.r, options.g, options.b, this.sprites);
        }
    }
}

