/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ScaffoldingBlockItem;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.item.loader.KItemTemplates;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class BlockItemTemplate
extends KItemTemplate {
    private final Optional<ResourceLocation> block;
    private final String clazz;
    private BiFunction<Block, Item.Properties, Item> constructor;

    public BlockItemTemplate(Optional<ItemDefinitionProperties> properties, Optional<ResourceLocation> block, String clazz) {
        super(properties);
        this.block = block;
        this.clazz = clazz;
    }

    public static MapCodec<BlockItemTemplate> directCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemDefinitionProperties.mapCodecField().forGetter(KItemTemplate::properties), (App)ResourceLocation.CODEC.optionalFieldOf("block").forGetter(BlockItemTemplate::block), (App)Codec.STRING.optionalFieldOf("class", (Object)"").forGetter(BlockItemTemplate::clazz)).apply((Applicative)instance, BlockItemTemplate::new));
    }

    @Override
    public KItemTemplate.Type<?> type() {
        return KItemTemplates.BLOCK.getOrCreate();
    }

    @Override
    public void resolve(ResourceLocation key, OneTimeLoader.Context context) {
        if (this.clazz.isEmpty()) {
            this.constructor = (block, properties) -> {
                if (block instanceof DoorBlock || block instanceof DoublePlantBlock) {
                    return new DoubleHighBlockItem(block, properties);
                }
                if (block instanceof BedBlock) {
                    return new BedItem(block, properties);
                }
                if (block instanceof ScaffoldingBlock) {
                    return new ScaffoldingBlockItem(block, properties);
                }
                return new BlockItem(block, properties);
            };
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.clazz);
            this.constructor = (block, properties) -> {
                try {
                    return (Item)clazz.getConstructor(Block.class, Item.Properties.class).newInstance(block, properties);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Item createItem(ResourceLocation id, Item.Properties properties, JsonObject json) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(this.block.orElse(id));
        Preconditions.checkState((block != Blocks.AIR ? 1 : 0) != 0, (String)"Block %s not found", this.block);
        return this.constructor.apply(block, properties);
    }

    public Optional<ResourceLocation> block() {
        return this.block;
    }

    public String clazz() {
        return this.clazz;
    }

    public String toString() {
        return "BlockItemTemplate[properties=" + String.valueOf(this.properties) + ", block=" + String.valueOf(this.block) + "]";
    }
}

