/*
 * Decompiled with CFR 0.152.
 */
package iquldev.fpsoverlay.render;

import iquldev.fpsoverlay.FPSOverlayConfig;
import iquldev.fpsoverlay.stats.FpsStats;
import iquldev.fpsoverlay.text.DynamicTextManager;
import iquldev.fpsoverlay.util.ColorUtils;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class OverlayRenderer {
    private static final int PADDING = 5;

    public static void renderOverlay(class_332 context, class_310 client, FpsStats fpsStats, DynamicTextManager dynamicTextManager, boolean isF1Pressed) {
        boolean isShowed = FPSOverlayConfig.isShowed;
        boolean isAdvancedShowed = FPSOverlayConfig.isAdvancedShowed;
        FPSOverlayConfig.OverlayPosition overlayPosition = FPSOverlayConfig.overlayPosition;
        int overlayBackgroundColor = ColorUtils.parseColor(FPSOverlayConfig.overlayBackgroundColor, FPSOverlayConfig.overlayTransparency);
        int advancedBackgroundColor = ColorUtils.parseColor(FPSOverlayConfig.advancedBackgroundColor, FPSOverlayConfig.advancedTransparency);
        int overlayTextColor = ColorUtils.parseColor(FPSOverlayConfig.overlayTextColor, 100);
        int advancedTextColor = ColorUtils.parseColor(FPSOverlayConfig.advancedTextColor, 100);
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        fpsStats.updateFps(client.method_47599());
        String overlayText = dynamicTextManager.getOverlayText(client, fpsStats);
        String advancedText = dynamicTextManager.getAdvancedText(client, fpsStats);
        int overlayTextWidth = client.field_1772.method_1727(overlayText);
        Objects.requireNonNull(client.field_1772);
        int overlayTextHeight = 9;
        int advancedTextWidth = client.field_1772.method_1727(advancedText);
        Position overlayPosition_ = OverlayRenderer.calculateOverlayPosition(overlayPosition, screenWidth, screenHeight, overlayTextWidth, overlayTextHeight);
        if (isShowed && !isF1Pressed) {
            OverlayRenderer.renderOverlayBox(context, overlayPosition_.x(), overlayPosition_.y(), overlayTextWidth, overlayTextHeight, overlayBackgroundColor);
            context.method_51433(client.field_1772, overlayText, overlayPosition_.x(), overlayPosition_.y(), overlayTextColor, false);
        }
        if (isAdvancedShowed && !isF1Pressed) {
            Position advancedPosition = OverlayRenderer.calculateAdvancedPosition(overlayPosition, overlayPosition_, advancedTextWidth, overlayTextWidth, overlayTextHeight, screenWidth, screenHeight, isShowed);
            OverlayRenderer.renderOverlayBox(context, advancedPosition.x(), advancedPosition.y(), advancedTextWidth, overlayTextHeight, advancedBackgroundColor);
            context.method_51433(client.field_1772, advancedText, advancedPosition.x(), advancedPosition.y(), advancedTextColor, false);
        }
    }

    private static Position calculateOverlayPosition(FPSOverlayConfig.OverlayPosition position, int screenWidth, int screenHeight, int textWidth, int textHeight) {
        return switch (position) {
            case FPSOverlayConfig.OverlayPosition.TOP_RIGHT -> new Position(screenWidth - 15 - textWidth - 5, 10);
            case FPSOverlayConfig.OverlayPosition.BOTTOM_LEFT -> new Position(15, screenHeight - 10 - textHeight - 5);
            case FPSOverlayConfig.OverlayPosition.BOTTOM_RIGHT -> new Position(screenWidth - 15 - textWidth - 5, screenHeight - 10 - textHeight - 5);
            default -> new Position(15, 10);
        };
    }

    private static Position calculateAdvancedPosition(FPSOverlayConfig.OverlayPosition position, Position overlayPos, int advancedTextWidth, int overlayTextWidth, int textHeight, int screenWidth, int screenHeight, boolean isShowed) {
        if (isShowed) {
            int x = switch (position) {
                case FPSOverlayConfig.OverlayPosition.TOP_RIGHT, FPSOverlayConfig.OverlayPosition.BOTTOM_RIGHT -> overlayPos.x() - advancedTextWidth - 20;
                default -> overlayPos.x() + overlayTextWidth + 20;
            };
            return new Position(x, overlayPos.y());
        }
        return switch (position) {
            case FPSOverlayConfig.OverlayPosition.TOP_RIGHT -> new Position(screenWidth - 10 - advancedTextWidth - 10, 10);
            case FPSOverlayConfig.OverlayPosition.BOTTOM_RIGHT -> new Position(screenWidth - 10 - advancedTextWidth - 10, screenHeight - 10 - textHeight - 5);
            case FPSOverlayConfig.OverlayPosition.BOTTOM_LEFT -> new Position(15, screenHeight - 10 - textHeight - 5);
            default -> new Position(15, 10);
        };
    }

    private static void renderOverlayBox(class_332 context, int x, int y, int width, int height, int color) {
        OverlayRenderer.drawRoundedRect(context, x - 5, y - 5, x + width + 5, y + height + 5, color);
    }

    private static void drawRoundedRect(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int paddingWidth = 3;
        int paddingHeight = 3;
        context.method_25294(x1, y1, x2, y2, color);
        context.method_25294(x1 - paddingWidth, y1 + paddingHeight, x1, y2 - paddingHeight, color);
        context.method_25294(x2, y1 + paddingHeight, x2 + paddingWidth, y2 - paddingHeight, color);
    }

    @Environment(value=EnvType.CLIENT)
    private record Position(int x, int y) {
    }
}

