/*
 * Decompiled with CFR 0.152.
 */
package iquldev.fpsoverlay.stats;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FpsStats {
    private int minFps = Integer.MAX_VALUE;
    private int maxFps = Integer.MIN_VALUE;
    private int currentFps = 0;
    private long lastUpdateTime = System.currentTimeMillis();
    private static final int UPDATE_INTERVAL = 30000;

    public void updateFps(int fps) {
        long currentTime;
        this.currentFps = fps;
        if (fps < this.minFps) {
            this.minFps = fps;
        }
        if (fps > this.maxFps) {
            this.maxFps = fps;
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastUpdateTime >= 30000L) {
            this.resetStats();
            this.lastUpdateTime = currentTime;
        }
    }

    public void resetStats() {
        this.minFps = this.currentFps;
        this.maxFps = this.currentFps;
    }

    public int getCurrentFps() {
        return this.currentFps;
    }

    public int getMinFps() {
        return this.minFps;
    }

    public int getMaxFps() {
        return this.maxFps;
    }
}

