/*
 * Decompiled with CFR 0.152.
 */
package iquldev.fpsoverlay.text;

import iquldev.fpsoverlay.FPSOverlayConfig;
import iquldev.fpsoverlay.stats.FpsStats;
import iquldev.fpsoverlay.text.TextFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DynamicTextManager {
    private boolean useOverlayDynamicText = false;
    private boolean useAdvancedDynamicText = false;
    private long lastOverlaySwitchTime = System.currentTimeMillis();
    private long lastAdvancedSwitchTime = System.currentTimeMillis();

    public void updateDynamicText() {
        long currentTime = System.currentTimeMillis();
        if (FPSOverlayConfig.overlayDynamicInterval > 0 && !FPSOverlayConfig.overlayDynamicText.isEmpty() && currentTime - this.lastOverlaySwitchTime >= (long)FPSOverlayConfig.overlayDynamicInterval * 1000L) {
            this.useOverlayDynamicText = !this.useOverlayDynamicText;
            this.lastOverlaySwitchTime = currentTime;
        }
        if (FPSOverlayConfig.advancedDynamicInterval > 0 && !FPSOverlayConfig.advancedDynamicText.isEmpty() && currentTime - this.lastAdvancedSwitchTime >= (long)FPSOverlayConfig.advancedDynamicInterval * 1000L) {
            this.useAdvancedDynamicText = !this.useAdvancedDynamicText;
            this.lastAdvancedSwitchTime = currentTime;
        }
    }

    public String getOverlayText(class_310 client, FpsStats fpsStats) {
        String textToFormat = FPSOverlayConfig.overlayDynamicInterval > 0 && this.useOverlayDynamicText ? FPSOverlayConfig.overlayDynamicText : FPSOverlayConfig.overlayText;
        return TextFormatter.formatText(textToFormat, client, fpsStats);
    }

    public String getAdvancedText(class_310 client, FpsStats fpsStats) {
        String textToFormat = FPSOverlayConfig.advancedDynamicInterval > 0 && this.useAdvancedDynamicText ? FPSOverlayConfig.advancedDynamicText : FPSOverlayConfig.advancedText;
        return TextFormatter.formatText(textToFormat, client, fpsStats);
    }

    public boolean isUsingOverlayDynamicText() {
        return this.useOverlayDynamicText;
    }

    public boolean isUsingAdvancedDynamicText() {
        return this.useAdvancedDynamicText;
    }
}

