/*
 * Decompiled with CFR 0.152.
 */
package iquldev.fpsoverlay.text;

import iquldev.fpsoverlay.FPSOverlayConfig;
import iquldev.fpsoverlay.stats.FpsStats;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class TextFormatter {
    private static volatile long lastSystemStatsTime = 0L;
    private static volatile String cachedCurrentRam = "0";
    private static volatile String cachedRamPercent = "0.0";
    private static final long SYSTEM_STATS_TTL_MS = 2000L;
    private static volatile long sessionStartTime = 0L;

    public static String formatText(String text, class_310 client, FpsStats fpsStats) {
        if (client.field_1724 == null) {
            return text;
        }
        String systemTime = String.format("%tH:%tM", System.currentTimeMillis(), System.currentTimeMillis());
        int hour = Integer.parseInt(String.format("%tH", System.currentTimeMillis()));
        String clockSymbol = TextFormatter.getClockSymbol(hour);
        String timeWithClock = String.format("%s %s", systemTime, clockSymbol);
        String x = String.format("%.1f", client.field_1724.method_23317());
        String y = String.format("%.1f", client.field_1724.method_23318());
        String z = String.format("%.1f", client.field_1724.method_23321());
        String facing = TextFormatter.getFacingDirection(client);
        double playerSpeed = Math.sqrt(Math.pow(client.field_1724.method_18798().field_1352, 2.0) + Math.pow(client.field_1724.method_18798().field_1351, 2.0) + Math.pow(client.field_1724.method_18798().field_1350, 2.0));
        String playerSpeedStr = String.format("%.2f \u26a1", playerSpeed);
        assert (client.field_1687 != null);
        String dayTime = client.field_1687.method_8532() % 24000L < 13000L ? "Day \ud83c\udf1e" : "Night \ud83c\udf19";
        text = text.replace("{fps}", TextFormatter.maybeColorNumber("{fps}", fpsStats.getCurrentFps()));
        text = text.replace("{x}", x);
        text = text.replace("{y}", y);
        text = text.replace("{z}", z);
        text = text.replace("{systemTime}", timeWithClock);
        text = text.replace("{minFps}", TextFormatter.maybeColorNumber("{minFps}", fpsStats.getMinFps()));
        text = text.replace("{maxFps}", TextFormatter.maybeColorNumber("{maxFps}", fpsStats.getMaxFps()));
        text = text.replace("{currentRam}", TextFormatter.getCurrentRam());
        text = text.replace("{maxRam}", TextFormatter.getMaxRam());
        text = text.replace("{ramPercent}", TextFormatter.getRamPercent());
        text = text.replace("{facing}", facing);
        text = text.replace("{playerSpeed}", playerSpeedStr);
        text = text.replace("{dayTime}", dayTime);
        text = text.replace("{worldTime}", TextFormatter.getWorldTime(client));
        text = text.replace("{weather}", TextFormatter.getWeather(client));
        text = text.replace("{sessionTime}", TextFormatter.getSessionTime());
        return text;
    }

    private static String maybeColorNumber(String placeholder, int value) {
        if (!FPSOverlayConfig.colorOnThreshold) {
            return String.valueOf(value);
        }
        int threshold = FPSOverlayConfig.colorThreshold;
        if (value < threshold) {
            return "\u00a7c" + value + "\u00a7r";
        }
        return String.valueOf(value);
    }

    private static String getClockSymbol(int hour) {
        if (hour >= 6 && hour < 12) {
            return "\ud83d\udd56";
        }
        if (hour >= 12 && hour < 18) {
            return "\ud83d\udd53";
        }
        if (hour >= 18 && hour < 22) {
            return "\ud83d\udd52";
        }
        return "\ud83d\udd70\ufe0f";
    }

    private static String getCurrentRam() {
        TextFormatter.updateSystemStatsIfNeeded();
        return cachedCurrentRam;
    }

    private static String getMaxRam() {
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        return String.valueOf(TextFormatter.bytesToMb(max));
    }

    private static String getRamPercent() {
        TextFormatter.updateSystemStatsIfNeeded();
        return cachedRamPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSystemStatsIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - lastSystemStatsTime <= 2000L) {
            return;
        }
        Class<TextFormatter> clazz = TextFormatter.class;
        synchronized (TextFormatter.class) {
            if (now - lastSystemStatsTime <= 2000L) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            try {
                Runtime rt = Runtime.getRuntime();
                long used = rt.totalMemory() - rt.freeMemory();
                long max = rt.maxMemory();
                long usedMb = TextFormatter.bytesToMb(used);
                cachedCurrentRam = String.valueOf(usedMb);
                if (max <= 0L) {
                    cachedRamPercent = "0.0";
                } else {
                    double pct = (double)used / (double)max * 100.0;
                    cachedRamPercent = String.format("%.1f", pct);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                lastSystemStatsTime = now;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private static String getWorldTime(class_310 client) {
        try {
            if (client.field_1687 == null) {
                return "00:00";
            }
            long time = client.field_1687.method_8532() % 24000L;
            long hourOffset = time / 1000L % 24L;
            long hours = (6L + hourOffset) % 24L;
            long ticksIntoHour = time % 1000L;
            long minutes = ticksIntoHour * 60L / 1000L;
            String clock = TextFormatter.getClockSymbol((int)hours);
            return String.format("%02d:%02d %s", hours, minutes, clock);
        }
        catch (Throwable t) {
            return "00:00";
        }
    }

    private static String getWeather(class_310 client) {
        try {
            if (client.field_1687 == null) {
                return "Clear \u2600\ufe0f";
            }
            boolean raining = client.field_1687.method_8419();
            boolean thunder = client.field_1687.method_8546();
            if (thunder) {
                return "Thunder \u26c8\ufe0f";
            }
            if (raining) {
                return "Rain \ud83c\udf27\ufe0f";
            }
            return "Clear \u2600\ufe0f";
        }
        catch (Throwable t) {
            return "Clear \u2600\ufe0f";
        }
    }

    private static String getSessionTime() {
        long now = System.currentTimeMillis();
        if (sessionStartTime == 0L) {
            sessionStartTime = now;
        }
        long diff = now - sessionStartTime;
        long totalSeconds = diff / 1000L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private static String getFacingDirection(class_310 client) {
        assert (client.field_1724 != null);
        float yaw = client.field_1724.method_36454();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return "South \ud83e\udded";
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return "West \ud83e\udded";
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return "North \ud83e\udded";
        }
        if (yaw >= 225.0f && yaw < 315.0f) {
            return "East \ud83e\udded";
        }
        return "Unknown";
    }
}

