/*
 * Decompiled with CFR 0.152.
 */
package iquldev.fpsoverlay.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorUtils {
    public static int parseColor(String colorStr, int transparency) {
        try {
            if (colorStr == null || colorStr.isEmpty()) {
                return Integer.MIN_VALUE;
            }
            if (colorStr.charAt(0) == '#') {
                colorStr = colorStr.substring(1);
            }
            int color = Integer.parseInt(colorStr, 16);
            int alpha = (int)((double)transparency * 2.55);
            return alpha << 24 | color;
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    public static int createColor(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int createColor(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }
}

