/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.api.config;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.api.config.IConfig;

public class Config
implements IConfig {
    private FileConfiguration configuration;
    private final JavaPlugin plugin;
    private File configFile;
    private String path;
    private final String fileName;
    private final boolean isPluginConfig;

    public Config(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configuration = plugin.getConfig();
        this.isPluginConfig = true;
        this.fileName = "config.yml";
    }

    public Config(JavaPlugin plugin, String path, String fileName) {
        this.isPluginConfig = false;
        this.plugin = plugin;
        this.fileName = fileName;
        if (path.isEmpty()) {
            this.configFile = new File(plugin.getDataFolder(), fileName);
            this.path = String.valueOf(plugin.getDataFolder()) + File.separator + fileName;
        } else {
            this.path = String.valueOf(plugin.getDataFolder()) + File.separator + path + File.separator + fileName;
            this.configFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + path, fileName);
            File parentDir = this.configFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
        }
        if (!this.configFile.exists()) {
            try {
                if (path.isEmpty()) {
                    plugin.saveResource(fileName, false);
                } else {
                    plugin.saveResource(path + File.separator + fileName, false);
                }
            }
            catch (IllegalArgumentException e) {
                plugin.getLogger().info("Creating new config file: " + fileName);
            }
        }
        this.configuration = new YamlConfiguration();
        this.configuration.options().copyDefaults(true);
        this.configuration.options().parseComments(true);
        try {
            this.configuration.load(this.configFile);
        }
        catch (Exception ex) {
            plugin.getLogger().warning("Failed to load config: " + fileName + " Error: " + ex.getMessage());
        }
    }

    @Override
    public void save() {
        if (this.isPluginConfig) {
            this.plugin.saveConfig();
        } else {
            try {
                this.configuration.save(this.configFile);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to save config: " + this.fileName + " Error: " + ex.getMessage());
            }
        }
    }

    @Override
    public void reload() {
        if (this.isPluginConfig) {
            this.plugin.reloadConfig();
            this.configuration = this.plugin.getConfig();
        } else {
            try {
                this.configuration.load(this.configFile);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to reload config: " + this.fileName + " Error: " + ex.getMessage());
            }
        }
    }

    @Override
    public void set(String path, Object value) {
        this.configuration.set(path, value);
    }

    @Override
    public void setComments(String path, String ... comments) {
        this.configuration.setComments(path, List.of(comments));
    }

    @Override
    public void addDefault(String path, Object value) {
        this.configuration.addDefault(path, value);
    }

    @Override
    public void addDefaultWithComments(String path, Object value, String ... comments) {
        this.configuration.addDefault(path, value);
        this.configuration.setComments(path, List.of(comments));
    }

    @Override
    public void remove(String path) {
        this.configuration.set(path, null);
    }

    @Override
    public boolean contains(String path) {
        return this.configuration.contains(path);
    }

    @Override
    public boolean isSet(String path) {
        return this.configuration.isSet(path);
    }

    @Override
    public Object get(String path) {
        return this.configuration.get(path);
    }

    @Override
    public Object get(String path, Object defaultValue) {
        return this.configuration.get(path, defaultValue);
    }

    @Override
    public String getString(String path) {
        return this.configuration.getString(path);
    }

    @Override
    public String getString(String path, String defaultValue) {
        return this.configuration.getString(path, defaultValue);
    }

    @Override
    public int getInt(String path) {
        return this.configuration.getInt(path);
    }

    @Override
    public int getInt(String path, int defaultValue) {
        return this.configuration.getInt(path, defaultValue);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.configuration.getBoolean(path);
    }

    @Override
    public boolean getBoolean(String path, boolean defaultValue) {
        return this.configuration.getBoolean(path, defaultValue);
    }

    @Override
    public double getDouble(String path) {
        return this.configuration.getDouble(path);
    }

    @Override
    public double getDouble(String path, double defaultValue) {
        return this.configuration.getDouble(path, defaultValue);
    }

    @Override
    public long getLong(String path) {
        return this.configuration.getLong(path);
    }

    @Override
    public long getLong(String path, long defaultValue) {
        return this.configuration.getLong(path, defaultValue);
    }

    @Override
    public Location getLocation(String path) {
        return this.configuration.getLocation(path);
    }

    @Override
    public List<String> getStringList(String path) {
        return this.configuration.getStringList(path);
    }

    @Override
    public List<Integer> getIntegerList(String path) {
        return this.configuration.getIntegerList(path);
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        return this.configuration.getKeys(deep);
    }

    @Override
    public Set<String> getKeys(String path, boolean deep) {
        ConfigurationSection section = this.configuration.getConfigurationSection(path);
        return section != null ? section.getKeys(deep) : new HashSet();
    }

    @Override
    public ConfigurationSection getConfigurationSection(String path) {
        return this.configuration.getConfigurationSection(path);
    }

    @Override
    public ConfigurationSection createSection(String path) {
        return this.configuration.createSection(path);
    }

    @Override
    public void saveDefaults() {
        if (!this.isPluginConfig) {
            this.configuration.options().copyDefaults(true);
            this.save();
        }
    }

    @Override
    public FileConfiguration getConfig() {
        return this.configuration;
    }

    public boolean exists() {
        if (this.isPluginConfig) {
            return this.plugin.getConfig() != null;
        }
        return this.configFile != null && this.configFile.exists();
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }
}

