/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.init;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.ziomalu.timeportals.commands.TimePortalCommand;
import pl.ziomalu.timeportals.listeners.PlayerListener;
import pl.ziomalu.timeportals.listeners.WorldChangeListener;
import pl.ziomalu.timeportals.managers.WorldsManager;
import pl.ziomalu.timeportals.message.Message;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.shaded.bstats.bukkit.Metrics;
import pl.ziomalu.timeportals.temp.TempPlayersManager;
import pl.ziomalu.timeportals.utils.BukkitConsole;
import pl.ziomalu.timeportals.utils.UpdateChecker;
import pl.ziomalu.timeportals.utils.Utils;

public final class Initialize {
    private final JavaPlugin plugin;

    public Initialize(JavaPlugin plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    private void initialize() {
        new Settings().load();
        new UpdateChecker((Plugin)this.plugin, 105052).getLatestVersion(latestVersion -> {
            UpdateChecker.Version currentVersion = Utils.getPluginVersion();
            boolean isNewer = latestVersion.isNewer(currentVersion);
            if (isNewer) {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r", "\u00a7ePlugin has an update\u00a78: \u00a78(\u00a7c" + latestVersion.getChannel().name() + " " + latestVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r \u00a7ecurrent version\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r", "\u00a77You can download from\u00a78:", "\u00a7fhttps://www.curseforge.com/minecraft/bukkit-plugins/timeportals", "\u00a7fhttps://www.spigotmc.org/resources/timeportals.105052/", "\u00a7fhttps://modrinth.com/plugin/timeportals", "\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r");
            } else if (currentVersion.getChannel() == UpdateChecker.VersionChannel.DEV) {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r", "\u00a7eYou are using a development version of the plugin\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "-" + currentVersion.getBuildNumber() + "\u00a78)\u00a7r", "\u00a7eLatest release: \u00a78(\u00a7c" + latestVersion.getChannel().name() + " " + latestVersion.getVersionData().getVersionString() + "\u00a78)", "\u00a77This version may be unstable and is intended for testing purposes only.", "\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r");
            } else {
                BukkitConsole.getInstance().sendMessage("\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r", "\u00a7aThe plugin is up to date\u00a78: \u00a78(\u00a7c" + currentVersion.getChannel().name() + " " + currentVersion.getVersionData().getVersionString() + "\u00a78)\u00a7r", "\u00a77=============================\u00a78[\u00a7eTimePortals\u00a78]\u00a77=============================\u00a7r");
            }
        });
        new Message();
        new TempPlayersManager();
        new WorldsManager();
        this.initializeEvents();
        TimePortalCommand timePortalCommand = new TimePortalCommand();
        this.plugin.getCommand("timeportals").setExecutor((CommandExecutor)timePortalCommand);
        this.plugin.getCommand("timeportals").setTabCompleter((TabCompleter)timePortalCommand);
        new Metrics(this.plugin, 16138);
    }

    private void initializeEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new WorldChangeListener(), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this.plugin);
    }
}

