/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.temp;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import pl.ziomalu.api.config.Config;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.temp.TempPlayer;

public class TempPlayersManager {
    private static TempPlayersManager instance;
    private final HashMap<UUID, TempPlayer> tempPlayers;
    private final Config config;

    public TempPlayersManager() {
        instance = this;
        this.tempPlayers = new HashMap();
        this.config = new Config(TimePortals.getInstance(), "", "players-locations.yml");
        this.load();
    }

    public void load() {
        if (!this.config.isSet("players")) {
            return;
        }
        ConfigurationSection playersSection = this.config.getConfigurationSection("players");
        if (playersSection == null) {
            return;
        }
        for (String uuidKey : playersSection.getKeys(false)) {
            try {
                String playerName;
                Location location;
                Set playerNames;
                ConfigurationSection playerSection;
                UUID playerUniqueId = UUID.fromString(uuidKey);
                Player player = Bukkit.getPlayer((UUID)playerUniqueId);
                if (player != null && player.isOnline() && "world".equals(player.getLocation().getWorld().getName()) || (playerSection = playersSection.getConfigurationSection(uuidKey)) == null || (playerNames = playerSection.getKeys(false)).isEmpty() || (location = this.config.getLocation("players." + uuidKey + "." + (playerName = (String)playerNames.iterator().next()) + ".location")) == null) continue;
                this.tempPlayers.put(playerUniqueId, new TempPlayer(playerUniqueId, playerName, location));
                TimePortals.getInstance().getLogger().info("Loaded player: " + playerName + " at " + location.getWorld().getName());
            }
            catch (IllegalArgumentException e) {
                TimePortals.getInstance().getLogger().warning("Invalid UUID in config: " + uuidKey);
            }
            catch (Exception e) {
                TimePortals.getInstance().getLogger().warning("Error loading player data for " + uuidKey + ": " + e.getMessage());
            }
        }
    }

    public boolean hasPlayer(Player player) {
        return this.tempPlayers.containsKey(player.getUniqueId());
    }

    public Optional<TempPlayer> getPlayer(Player player) {
        TempPlayer tmp = this.tempPlayers.getOrDefault(player.getUniqueId(), null);
        return tmp != null ? Optional.of(tmp) : Optional.empty();
    }

    public void removePlayer(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.tempPlayers.containsKey(playerId)) {
            return;
        }
        this.tempPlayers.remove(playerId);
        TimePortals.getInstance().foliaLib.getScheduler().runAsync(task -> {
            try {
                if (!this.config.isSet("players")) {
                    return;
                }
                ConfigurationSection playersSection = this.config.getConfigurationSection("players");
                if (playersSection == null) {
                    return;
                }
                String uuidString = playerId.toString();
                if (playersSection.contains(uuidString)) {
                    playersSection.set(uuidString, null);
                    this.config.save();
                    TimePortals.getInstance().getLogger().info("Removed player data: " + player.getName());
                }
            }
            catch (Exception e) {
                TimePortals.getInstance().getLogger().warning("Failed to remove player data: " + e.getMessage());
            }
        });
    }

    public void addPlayer(TempPlayer tempPlayer) {
        this.tempPlayers.put(tempPlayer.playerUniqueId(), tempPlayer);
    }

    public void savePlayerLastLocAsync(TempPlayer tempPlayer) {
        TimePortals.getInstance().foliaLib.getScheduler().runAsync(task -> {
            try {
                this.config.set("players." + String.valueOf(tempPlayer.playerUniqueId()) + "." + tempPlayer.playerName() + ".location", tempPlayer.lastLocation());
                this.config.save();
            }
            catch (Exception e) {
                TimePortals.getInstance().getLogger().warning("Failed to save player location: " + e.getMessage());
            }
        });
    }

    public void savePlayerLastLoc(TempPlayer tempPlayer) {
        try {
            this.config.set("players." + String.valueOf(tempPlayer.playerUniqueId()) + "." + tempPlayer.playerName() + ".location", tempPlayer.lastLocation());
            this.config.save();
        }
        catch (Exception e) {
            TimePortals.getInstance().getLogger().warning("Failed to save player location: " + e.getMessage());
        }
    }

    public void savePlayers() {
        if (this.tempPlayers.isEmpty()) {
            return;
        }
        this.tempPlayers.values().forEach(this::savePlayerLastLoc);
    }

    public static TempPlayersManager getInstance() {
        return instance;
    }
}

