/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import pl.ziomalu.timeportals.TimePortals;

public class UpdateChecker {
    private final int resourceId;
    private final Plugin plugin;

    public UpdateChecker(Plugin plugin, int resourceId) {
        this.resourceId = resourceId;
        this.plugin = plugin;
    }

    public void getLatestVersion(Consumer<Version> consumer) {
        TimePortals.getInstance().foliaLib.getScheduler().runAsync(task -> {
            block13: {
                try (InputStream inputStream = URI.create("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).toURL().openStream();){
                    VersionChannel channel;
                    Scanner scanner = new Scanner(inputStream);
                    if (!scanner.hasNext()) break block13;
                    String line = scanner.nextLine();
                    if ("1.0.2".equalsIgnoreCase(line)) {
                        line = "RELEASE 1.0.2";
                    }
                    String[] splited = line.split(" ");
                    if (line.isEmpty() || splited.length < 2) {
                        this.plugin.getLogger().warning("Invalid update data received from API.");
                        return;
                    }
                    try {
                        channel = VersionChannel.valueOf(splited[0].replace("Relase", "RELEASE").toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Unknown version channel: " + splited[0]);
                        channel = VersionChannel.RELEASE;
                    }
                    String version = splited[1];
                    consumer.accept(new Version(version, channel));
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Could not find the latest version: " + e.getMessage());
                }
            }
        });
    }

    public static enum VersionChannel {
        RELEASE,
        BETA,
        ALPHA,
        DEV;

    }

    public static class Version {
        private final VersionData versionData;
        private final VersionChannel channel;
        private final int buildNumber;

        public Version(String version, VersionChannel channel) {
            this.versionData = new VersionData(version);
            this.channel = channel;
            this.buildNumber = 0;
        }

        public Version(String version, VersionChannel channel, int buildNumber) {
            this.versionData = new VersionData(version);
            this.channel = channel;
            this.buildNumber = buildNumber;
        }

        public boolean isNewer(Version other) {
            int versionComparison = this.versionData.compareTo(other.versionData);
            if (versionComparison != 0) {
                return versionComparison > 0;
            }
            if (this.channel != VersionChannel.RELEASE && other.channel == VersionChannel.RELEASE) {
                return false;
            }
            if (this.channel == VersionChannel.RELEASE && other.channel != VersionChannel.RELEASE) {
                return true;
            }
            return this.buildNumber > other.buildNumber;
        }

        public String toString() {
            return "Version{versionData=" + String.valueOf(this.versionData) + ", channel=" + String.valueOf((Object)this.channel) + ", buildNumber=" + this.buildNumber + "}";
        }

        public VersionData getVersionData() {
            return this.versionData;
        }

        public VersionChannel getChannel() {
            return this.channel;
        }

        public int getBuildNumber() {
            return this.buildNumber;
        }
    }

    public static class VersionData {
        private final int major;
        private final int minor;
        private final int patch;

        public VersionData(String version) {
            String[] parts = version.split("\\.");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid version format. Expected format: 'major.minor.patch'");
            }
            this.major = Integer.parseInt(parts[0]);
            this.minor = Integer.parseInt(parts[1]);
            this.patch = Integer.parseInt(parts[2]);
        }

        public VersionData(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int compareTo(VersionData other) {
            if (this.major != other.major) {
                return this.major - other.major;
            }
            if (this.minor != other.minor) {
                return this.minor - other.minor;
            }
            return this.patch - other.patch;
        }

        public String getVersionString() {
            return String.format("%s.%s.%s", this.major, this.minor, this.patch);
        }

        public String toString() {
            return "VersionData{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + "}";
        }
    }
}

