/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.utils;

import java.util.Arrays;
import java.util.stream.Collectors;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.utils.UpdateChecker;

public final class Utils {
    public static String fixWorldName(String worldName) {
        if (worldName == null || worldName.isBlank()) {
            return "";
        }
        return Arrays.stream(worldName.replace("_", " ").trim().split("\\s+")).filter(s -> !s.isEmpty()).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" "));
    }

    public static UpdateChecker.Version getPluginVersion() {
        UpdateChecker.VersionChannel channel;
        String pluginVersionAll = TimePortals.getInstance().getDescription().getVersion();
        String[] splitVersion = pluginVersionAll.split("-");
        String pluginVersionStr = splitVersion[0];
        try {
            channel = splitVersion.length == 1 ? UpdateChecker.VersionChannel.RELEASE : UpdateChecker.VersionChannel.valueOf(splitVersion[1].replace("Release", "RELEASE").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            TimePortals.getInstance().getLogger().warning("Unknown version channel: " + splitVersion[1]);
            channel = UpdateChecker.VersionChannel.RELEASE;
        }
        int buildNumber = 0;
        try {
            if (splitVersion.length == 3) {
                buildNumber = channel == UpdateChecker.VersionChannel.DEV ? Integer.parseInt(splitVersion[2]) : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new UpdateChecker.Version(pluginVersionStr, channel, buildNumber);
    }
}

