/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.world;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import pl.ziomalu.api.config.Config;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.managers.WorldsManager;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.temp.TempPlayer;
import pl.ziomalu.timeportals.temp.TempPlayersManager;
import pl.ziomalu.timeportals.utils.Text;
import pl.ziomalu.timeportals.utils.Time;
import pl.ziomalu.timeportals.utils.Utils;

public class WorldData {
    private boolean automaticOpen;
    private boolean isOpen;
    private boolean forceClosed;
    private LocalDateTime openDate;
    private final World world;
    private Time openTime;
    private Time closeTime;
    private boolean isIgnored;
    private long secondsUntilOpen = -1L;
    private long secondsUntilClose = -1L;
    private int lastOpenAnnouncement = -1;
    private int lastCloseAnnouncement = -1;

    public WorldData(World world) {
        this(world, LocalDateTime.now(), "00:00:00", "00:00:00", false, true);
    }

    public WorldData(World world, LocalDateTime openDate) {
        this(world, openDate, "00:00:00", "00:00:00", false, true);
    }

    public WorldData(World world, LocalDateTime openDate, String openTime, String closeTime, boolean automaticOpen, boolean isIgnored) {
        this.world = world;
        this.openDate = openDate != null ? openDate : LocalDateTime.now();
        this.automaticOpen = automaticOpen;
        this.forceClosed = false;
        this.isIgnored = isIgnored;
        this.isOpen = this.dateIsAfter();
        if (this.dateFormatIsValid(openTime)) {
            this.openTime = new Time(openTime);
        } else {
            this.openTime = new Time(0);
            TimePortals.getInstance().getLogger().info(() -> "Invalid openTime format for world " + world.getName() + ", defaulting to 00:00:00");
        }
        if (this.dateFormatIsValid(closeTime)) {
            this.closeTime = new Time(closeTime);
        } else {
            this.closeTime = new Time(0);
            TimePortals.getInstance().getLogger().info(() -> "Invalid closeTime format for world " + world.getName() + ", defaulting to 00:00:00");
        }
    }

    public WorldData(World world, Config config) {
        this.world = world;
        String path = "worlds." + world.getName().toLowerCase() + ".";
        String openDateStr = config.getString(path + "openDate");
        if (openDateStr == null || !this.openDateIsValid(openDateStr)) {
            openDateStr = WorldsManager.DATE_TIME_FORMATTER.format(LocalDateTime.now());
            TimePortals.getInstance().getLogger().warning("Invalid or missing openDate in config for world " + world.getName() + ", defaulting to now");
        }
        try {
            this.openDate = LocalDateTime.parse(openDateStr, WorldsManager.DATE_TIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            this.openDate = LocalDateTime.now();
            TimePortals.getInstance().getLogger().warning("Failed to parse openDate for world " + world.getName() + ", defaulting to now");
        }
        String openTimeStr = config.getString(path + "openTime", "00:00:00");
        this.openTime = this.dateFormatIsValid(openTimeStr) ? new Time(openTimeStr) : new Time(0);
        String closeTimeStr = config.getString(path + "closeTime", "00:00:00");
        this.closeTime = this.dateFormatIsValid(closeTimeStr) ? new Time(closeTimeStr) : new Time(0);
        this.automaticOpen = config.getBoolean(path + "automatic-open", false);
        this.forceClosed = config.getBoolean(path + "force-closed", false);
        this.isIgnored = config.getBoolean(path + "ignore", true);
        this.isOpen = config.getBoolean(path + "isOpen", true);
    }

    public String toString() {
        return String.format("World: %s automaticOpen: %s forceClosed: %s openDate: %s isOpen: %s isIgnored: %s openTime: %s closeTime: %s", this.world.getName(), this.automaticOpen, this.forceClosed, WorldsManager.DATE_TIME_FORMATTER.format(this.openDate), this.isOpen, this.isIgnored, this.openTime != null ? this.openTime.toString() : "null", this.closeTime != null ? this.closeTime.toString() : "null");
    }

    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_HEADER.replace("%world_name%", Utils.fixWorldName(this.world.getName()))));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_AUTOMATIC_OPEN.replace("%automatic_open%", this.automaticOpen ? "&2true" : "&cfalse")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_IS_OPEN.replace("%is_open%", this.isOpen ? "&2true" : "&cfalse")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_FORCE_CLOSED.replace("%force_closed%", this.forceClosed ? "&2true" : "&cfalse")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_OPEN_DATE.replace("%open_date%", WorldsManager.DATE_TIME_FORMATTER.format(this.openDate))));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_OPEN_TIME.replace("%open_time%", this.openTime != null ? this.openTime.toString() : "00:00")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_CLOSE_TIME.replace("%close_time%", this.closeTime != null ? this.closeTime.toString() : "00:00")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_IS_IGNORED.replace("%is_ignored%", this.isIgnored ? "&2true" : "&cfalse")));
        list.add(Text.setColour(Settings.WORLDS_INFO_MENU_FOOTER.replace("%world_name%", Utils.fixWorldName(this.world.getName()))));
        return list;
    }

    public boolean setOpenTime(String openTimeStr) {
        if (this.dateFormatIsValid(openTimeStr)) {
            this.openTime = new Time(openTimeStr);
            return true;
        }
        return false;
    }

    public boolean setCloseTime(String closeTimeStr) {
        if (this.dateFormatIsValid(closeTimeStr)) {
            this.closeTime = new Time(closeTimeStr);
            return true;
        }
        return false;
    }

    public boolean setOpenDate(String openDateStr) {
        if (!this.openDateIsValid(openDateStr)) {
            return false;
        }
        try {
            this.openDate = LocalDateTime.parse(openDateStr, WorldsManager.DATE_TIME_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            TimePortals.getInstance().getLogger().log(Level.WARNING, "Invalid openDate format: " + openDateStr);
            return false;
        }
    }

    public boolean dateIsAfter() {
        return LocalDateTime.now().isAfter(this.openDate);
    }

    public boolean dateFormatIsValid(String date) {
        if (date == null) {
            return false;
        }
        String regex = "^(?:[01]?\\d|2[0-3])(?::[0-5]?\\d(?::[0-5]?\\d)?)?$";
        return Pattern.matches(regex, date);
    }

    public boolean openDateIsValid(String date) {
        if (date == null) {
            return false;
        }
        String regex = "^\\d{4}/(0[1-9]|1[0-2])/(0[1-9]|[12]\\d|3[01])-(0\\d|1\\d|2[0-3]):([0-5]\\d):([0-5]\\d)$";
        return Pattern.matches(regex, date);
    }

    public void kickPlayerFromWorld() {
        if (this.world.getPlayers().isEmpty()) {
            return;
        }
        for (Player player : this.world.getPlayers()) {
            Optional<TempPlayer> optional = TempPlayersManager.getInstance().getPlayer(player);
            Location lastLocation = optional.map(TempPlayer::lastLocation).orElseGet(() -> {
                Location respawnLocation = player.getRespawnLocation();
                if (respawnLocation == null) {
                    respawnLocation = player.getBedSpawnLocation();
                }
                return respawnLocation != null ? respawnLocation : WorldsManager.getInstance().getWorldSpawn();
            });
            player.teleport(lastLocation);
            TempPlayersManager.getInstance().removePlayer(player);
        }
    }

    public void kickPlayerFromWorld(Player player) {
        Optional<TempPlayer> optional = TempPlayersManager.getInstance().getPlayer(player);
        Location lastLocation = optional.map(TempPlayer::lastLocation).orElseGet(() -> {
            Location respawnLocation = player.getRespawnLocation();
            if (respawnLocation == null) {
                respawnLocation = player.getBedSpawnLocation();
            }
            return respawnLocation != null ? respawnLocation : WorldsManager.getInstance().getWorldSpawn();
        });
        player.teleport(lastLocation);
        TempPlayersManager.getInstance().removePlayer(player);
    }

    public String getOpenDateString() {
        return WorldsManager.DATE_TIME_FORMATTER.format(this.openDate);
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
        this.saveConfigValueAsync("isOpen", open);
    }

    public void setForceClosed(boolean forceClosed) {
        this.forceClosed = forceClosed;
        this.saveConfigValueAsync("force-closed", forceClosed);
    }

    public void setAutomaticOpen(boolean automaticOpen) {
        this.automaticOpen = automaticOpen;
        this.saveConfigValueAsync("automatic-open", automaticOpen);
    }

    public void setIgnored(boolean ignored) {
        this.isIgnored = ignored;
        this.saveConfigValueAsync("ignore", ignored);
    }

    private void saveConfigValueAsync(String key, Object value) {
        TimePortals.getInstance().foliaLib.getScheduler().runLaterAsync(() -> {
            Config config = WorldsManager.getInstance().getConfig();
            String path = "worlds." + this.world.getName().toLowerCase();
            config.set(path + "." + key, value);
            config.save();
        }, 20L);
    }

    public void saveTime() {
        TimePortals.getInstance().foliaLib.getScheduler().runLaterAsync(() -> {
            Config config = WorldsManager.getInstance().getConfig();
            String path = "worlds." + this.world.getName().toLowerCase();
            config.set(path + ".openTime", String.format("%02d:%02d:%02d", this.openTime.getHour(), this.openTime.getMinutes(), this.openTime.getSeconds()));
            config.set(path + ".closeTime", String.format("%02d:%02d:%02d", this.closeTime.getHour(), this.closeTime.getMinutes(), this.closeTime.getSeconds()));
            config.set(path + ".openDate", WorldsManager.DATE_TIME_FORMATTER.format(this.openDate));
            config.save();
        }, 20L);
    }

    public void close() {
        if (this.isOpen) {
            WorldsManager.getInstance().sendWorldCloseMessage(this.world);
        }
        this.kickPlayerFromWorld();
        this.setOpen(false);
    }

    public void open() {
        if (!this.isOpen) {
            WorldsManager.getInstance().sendWorldOpenMessage(this.world);
        }
        this.setOpen(true);
    }

    public boolean isAutomaticOpen() {
        return this.automaticOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isForceClosed() {
        return this.forceClosed;
    }

    public LocalDateTime getOpenDate() {
        return this.openDate;
    }

    public World getWorld() {
        return this.world;
    }

    public Time getOpenTime() {
        return this.openTime;
    }

    public Time getCloseTime() {
        return this.closeTime;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public long getSecondsUntilOpen() {
        return this.secondsUntilOpen;
    }

    public long getSecondsUntilClose() {
        return this.secondsUntilClose;
    }

    public int getLastOpenAnnouncement() {
        return this.lastOpenAnnouncement;
    }

    public int getLastCloseAnnouncement() {
        return this.lastCloseAnnouncement;
    }

    public void setSecondsUntilOpen(long secondsUntilOpen) {
        this.secondsUntilOpen = secondsUntilOpen;
    }

    public void setSecondsUntilClose(long secondsUntilClose) {
        this.secondsUntilClose = secondsUntilClose;
    }

    public void setLastOpenAnnouncement(int lastOpenAnnouncement) {
        this.lastOpenAnnouncement = lastOpenAnnouncement;
    }

    public void setLastCloseAnnouncement(int lastCloseAnnouncement) {
        this.lastCloseAnnouncement = lastCloseAnnouncement;
    }
}

