/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.managers;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import pl.ziomalu.api.config.Config;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.message.Message;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.shaded.folialib.wrapper.task.WrappedTask;
import pl.ziomalu.timeportals.tasks.WorldsTask;
import pl.ziomalu.timeportals.utils.Utils;
import pl.ziomalu.timeportals.world.WorldData;

public final class WorldsManager {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd-HH:mm:ss");
    private static WorldsManager instance;
    private final Config config;
    private final HashMap<String, WorldData> worlds;
    private final WorldsTask worldsTask;
    private WrappedTask wrappedWorldTask;

    public List<String> getWorldsNames() {
        return this.worlds.keySet().stream().toList();
    }

    public WorldsManager() {
        instance = this;
        this.config = new Config(TimePortals.getInstance(), "", "worlds.yml");
        this.worlds = new HashMap();
        this.worldsTask = new WorldsTask();
        this.loadWorlds();
        this.wrappedWorldTask = TimePortals.getInstance().foliaLib.getScheduler().runTimer(this.worldsTask, 1L, 20L);
    }

    public Optional<WorldData> getWorldData(String worldName) {
        WorldData worldData = this.worlds.getOrDefault(worldName, null);
        return Optional.ofNullable(worldData);
    }

    public List<WorldData> getWorldsData() {
        return this.worlds.values().stream().toList();
    }

    public void loadWorlds() {
        this.worlds.clear();
        String pathPrefix = "worlds.";
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName().toLowerCase();
            if ("world".equalsIgnoreCase(worldName)) continue;
            String worldKey = "worlds." + worldName;
            if (!this.config.isSet(worldKey)) {
                this.createDefaultWorldConfig(world);
            }
            try {
                WorldData worldData = new WorldData(world, this.config);
                this.worlds.put(worldName, worldData);
            }
            catch (Exception e) {
                TimePortals.getInstance().getLogger().warning(() -> String.format("Failed to load world: %s - check worlds.yml format", world.getName()));
            }
        }
        this.worldsTask.setWorlds(this.getWorldsData());
    }

    private void createDefaultWorldConfig(World world) {
        LocalDateTime now = LocalDateTime.now();
        String path = "worlds." + world.getName().toLowerCase();
        this.config.set(path + ".automatic-open", false);
        this.config.set(path + ".isOpen", true);
        this.config.set(path + ".force-closed", false);
        this.config.set(path + ".openDate", DATE_TIME_FORMATTER.format(now));
        this.config.set(path + ".openTime", "00:00:00");
        this.config.set(path + ".closeTime", "00:00:00");
        this.config.set(path + ".ignore", true);
        this.config.save();
    }

    public Location getWorldSpawn() {
        World world = (World)Bukkit.getWorlds().get(0);
        return world.getSpawnLocation();
    }

    public World getDefaultWorld() {
        return (World)Bukkit.getWorlds().get(0);
    }

    public void sendWorldOpenMessage(World world) {
        String message = Settings.WORLD_ENABLED_MESSAGE.replace("%world%", Utils.fixWorldName(world.getName()));
        Message.sendGlobalMessage(message);
    }

    public void sendWorldCloseMessage(World world) {
        String message = Settings.WORLD_DISABLED_MESSAGE.replace("%world%", Utils.fixWorldName(world.getName()));
        Message.sendGlobalMessage(message);
    }

    public static WorldsManager getInstance() {
        return instance;
    }

    public Config getConfig() {
        return this.config;
    }

    public WrappedTask getWrappedWorldTask() {
        return this.wrappedWorldTask;
    }
}

