/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.message;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.utils.Text;

public class Message {
    private static Message instance;
    private static HashMap<UUID, Long> messagesCooldown;
    private static final long COOLDOWN_TIME_MS = 10000L;

    public Message() {
        instance = this;
        messagesCooldown = new HashMap();
        TimePortals.getInstance().foliaLib.getScheduler().runTimerAsync(Message::cleanUpCooldowns, 1200L, 1200L);
    }

    public static void sendOnceMessage(Player player, String message) {
        Message.cleanUpCooldowns();
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (!messagesCooldown.containsKey(playerUUID)) {
            messagesCooldown.put(playerUUID, currentTime);
            player.sendMessage(Text.setColour(message));
        } else {
            long lastSent = messagesCooldown.get(playerUUID);
            long timeElapsed = currentTime - lastSent;
            if (timeElapsed >= 10000L) {
                messagesCooldown.put(playerUUID, currentTime);
                player.sendMessage(Text.setColour(message));
            }
        }
    }

    private static void cleanUpCooldowns() {
        long now = System.currentTimeMillis();
        messagesCooldown.entrySet().removeIf(entry -> now - (Long)entry.getValue() >= 10000L);
    }

    public static void sendGlobalMessage(String message) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> player.sendMessage(Text.setColour(message)));
    }

    public static Message getInstance() {
        return instance;
    }
}

