/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.temp;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import pl.ziomalu.api.config.Config;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.temp.TempPlayer;

public class TempPlayersManager {
    private static TempPlayersManager instance;
    private final HashMap<UUID, TempPlayer> tempPlayers;
    private final Config config;

    public TempPlayersManager() {
        instance = this;
        this.tempPlayers = new HashMap();
        this.config = new Config(TimePortals.getInstance(), "", "players-locations.yml");
        this.load();
    }

    public void load() {
        if (!this.config.isSet("players")) {
            return;
        }
        for (String key : this.config.getConfigurationSection("players").getKeys(false)) {
            UUID playerUniqueId = UUID.fromString(key);
            Player player = Bukkit.getPlayer((UUID)playerUniqueId);
            if (player != null && Bukkit.getOnlinePlayers().contains(player) && player.getLocation().getWorld().getName().equals("world")) {
                return;
            }
            String playerName = this.config.getString("players." + key);
            String path = "players." + String.valueOf(playerUniqueId) + "." + playerName;
            Location location = this.config.getLocation(path + ".location");
            this.tempPlayers.put(playerUniqueId, new TempPlayer(playerUniqueId, playerName, location));
        }
    }

    public boolean hasPlayer(Player player) {
        return this.tempPlayers.containsKey(player.getUniqueId());
    }

    public Optional<TempPlayer> getPlayer(Player player) {
        TempPlayer tmp = this.tempPlayers.getOrDefault(player.getUniqueId(), null);
        return tmp != null ? Optional.of(tmp) : Optional.empty();
    }

    public void removePlayer(final Player player) {
        if (!this.tempPlayers.containsKey(player.getUniqueId())) {
            return;
        }
        TimePortals.getInstance().foliaLib.getScheduler().runLaterAsync(new Runnable(){

            @Override
            public void run() {
                TempPlayersManager.this.tempPlayers.remove(player.getUniqueId());
                if (!TempPlayersManager.this.config.isSet("players")) {
                    return;
                }
                ConfigurationSection playersSection = TempPlayersManager.this.config.getConfigurationSection("players");
                if (playersSection == null) {
                    return;
                }
                if (playersSection.contains(player.getUniqueId().toString())) {
                    playersSection.set(player.getUniqueId().toString(), null);
                    TempPlayersManager.this.config.save();
                }
            }
        }, 20L);
    }

    public void addPlayer(TempPlayer tempPlayer) {
        this.tempPlayers.put(tempPlayer.playerUniqueId(), tempPlayer);
    }

    public void savePlayerLastLoc(final TempPlayer tempPlayer) {
        TimePortals.getInstance().foliaLib.getScheduler().runLaterAsync(new Runnable(){

            @Override
            public void run() {
                TempPlayersManager.this.config.set("players." + String.valueOf(tempPlayer.playerUniqueId()) + "." + tempPlayer.playerName() + ".location", tempPlayer.lastLocation());
                TempPlayersManager.this.config.save();
            }
        }, 20L);
    }

    public void savePlayers() {
        if (this.tempPlayers.isEmpty()) {
            return;
        }
        this.tempPlayers.values().forEach(this::savePlayerLastLoc);
    }

    public static TempPlayersManager getInstance() {
        return instance;
    }
}

