/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.utils;

import java.util.Objects;
import pl.ziomalu.timeportals.TimePortals;

public class Time {
    private int hour;
    private int minutes;
    private int seconds;

    private void validateAndSetTime(int hour, int minutes, int seconds) {
        if (hour < 0 || hour >= 24 || minutes < 0 || minutes >= 60 || seconds < 0 || seconds >= 60) {
            throw new IllegalArgumentException("Invalid time components: " + hour + ":" + minutes + ":" + seconds);
        }
        this.hour = hour;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public Time(int hour, int minutes, int seconds) {
        this.validateAndSetTime(hour, minutes, seconds);
    }

    public Time(int hour, int minutes) {
        this(hour, minutes, 0);
    }

    public Time(int hour) {
        this(hour, 0, 0);
    }

    public Time(String time) {
        if (time == null || time.isBlank()) {
            TimePortals.getInstance().getLogger().warning("Invalid Time Format: null or blank value!");
            this.validateAndSetTime(0, 0, 0);
            return;
        }
        String[] timeSplit = time.trim().split(":");
        if (timeSplit.length < 1 || timeSplit.length > 3) {
            TimePortals.getInstance().getLogger().warning("Invalid Time Format: " + time);
            this.validateAndSetTime(0, 0, 0);
            return;
        }
        try {
            int hour = Integer.parseInt(timeSplit[0]);
            int minutes = timeSplit.length > 1 ? Integer.parseInt(timeSplit[1]) : 0;
            int seconds = timeSplit.length > 2 ? Integer.parseInt(timeSplit[2]) : 0;
            this.validateAndSetTime(hour, minutes, seconds);
        }
        catch (NumberFormatException ex) {
            TimePortals.getInstance().getLogger().warning("Invalid Time Format (parsing error): " + time);
            this.validateAndSetTime(0, 0, 0);
        }
    }

    public String toString() {
        if (this.seconds == 0) {
            return String.format("&f%02d&8:&f%02d", this.hour, this.minutes);
        }
        return String.format("&f%02d&8:&f%02d&8:&f%02d", this.hour, this.minutes, this.seconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Time)) {
            return false;
        }
        Time time = (Time)o;
        return this.hour == time.hour && this.minutes == time.minutes && this.seconds == time.seconds;
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.minutes, this.seconds);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }
}

