/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.commands;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.managers.WorldsManager;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.shaded.jetbrains.annotations.NotNull;
import pl.ziomalu.timeportals.shaded.jetbrains.annotations.Nullable;
import pl.ziomalu.timeportals.utils.Text;
import pl.ziomalu.timeportals.utils.Utils;
import pl.ziomalu.timeportals.world.WorldData;

public class TimePortalCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            switch (args[0]) {
                case "reload": {
                    if (!sender.hasPermission("timeportals.reload")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    TimePortals.getInstance().reloadConfig();
                    Settings.getInstance().load();
                    WorldsManager.getInstance().loadWorlds();
                    sender.sendMessage(Text.setColour(Settings.PLUGIN_RELOADED_MESSAGE));
                    return true;
                }
                case "localtime": {
                    if (!sender.hasPermission("timeportals.localtime")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    sender.sendMessage(Text.setColour(Settings.COMMAND_LOCALTIME_MESSAGE.replace("%time%", WorldsManager.DATE_TIME_FORMATTER.format(LocalDateTime.now()))));
                    return true;
                }
                case "worlds": {
                    if (!sender.hasPermission("timeportals.worlds")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    List<WorldData> worlds = WorldsManager.getInstance().getWorldsData();
                    sender.sendMessage(Text.setColour(Settings.COMMAND_WORLDS_HEADER));
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        for (WorldData world : worlds) {
                            TextComponent message = new TextComponent(Text.setColour(Settings.COMMAND_WORLDS_WORLD_LINE.replace("%world%", world.getWorld().getName())));
                            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/timeportals info " + world.getWorld().getName()));
                            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(Text.setColour(Settings.COMMAND_WORLDS_WORLD_LINE_HOVER.replace("%world%", Utils.fixWorldName(world.getWorld().getName())))).create()));
                            player.spigot().sendMessage((BaseComponent)message);
                        }
                    } else {
                        for (WorldData world : worlds) {
                            sender.sendMessage(Settings.COMMAND_WORLDS_WORLD_LINE.replace("%world%", world.getWorld().getName()));
                        }
                    }
                    sender.sendMessage(Text.setColour(Settings.COMMAND_WORLDS_FOOTER));
                    return true;
                }
            }
            this.sendUsage(sender);
            return true;
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "info": {
                    if (!sender.hasPermission("timeportals.manage.worlds.info")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    worldDataOptional.get().toStringList().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "ignore": {
                    WorldData worldData;
                    if (!sender.hasPermission("timeportals.manage.worlds.ignore")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    worldData.setIgnored(!(worldData = worldDataOptional.get()).isIgnored());
                    worldDataOptional.get().toStringList().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "open": {
                    if (!sender.hasPermission("timeportals.manage.worlds.open")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    if (worldData.isOpen()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_ALREADY_OPEN.replace("%world%", args[1])));
                        return false;
                    }
                    worldData.setIgnored(true);
                    worldData.setOpen(true);
                    worldData.setAutomaticOpen(false);
                    sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_OPENED.replace("%world%", args[1])));
                    WorldsManager.getInstance().sendWorldOpenMessage(worldData.getWorld());
                    return true;
                }
                case "close": {
                    if (!sender.hasPermission("timeportals.manage.worlds.close")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    if (!worldData.isOpen()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_ALREADY_CLOSED.replace("%world%", args[1])));
                        return false;
                    }
                    worldData.setIgnored(true);
                    worldData.setOpen(false);
                    worldData.setAutomaticOpen(false);
                    worldData.kickPlayerFromWorld();
                    sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_CLOSED.replace("%world%", args[1])));
                    WorldsManager.getInstance().sendWorldCloseMessage(worldData.getWorld());
                    return true;
                }
                case "disable": {
                    if (!sender.hasPermission("timeportals.manage.worlds.disable")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    boolean forceClosed = !worldData.isForceClosed();
                    worldData.setForceClosed(forceClosed);
                    if (forceClosed) {
                        worldData.setForceClosed(true);
                        worldData.kickPlayerFromWorld();
                        WorldsManager.getInstance().sendWorldCloseMessage(worldData.getWorld());
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_DISABLED.replace("%world%", args[1])));
                    } else {
                        worldData.setForceClosed(false);
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_ENABLED.replace("%world%", args[1])));
                    }
                    return true;
                }
            }
            this.sendUsage(sender);
            return true;
        }
        if (args.length == 3) {
            switch (args[0]) {
                case "open-date": {
                    if (!sender.hasPermission("timeportals.manage.opendate")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    if (args[2].isEmpty() || args[2].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_INVALID_OPEN_DATE));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    if (!worldData.setOpenDate(args[1])) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_INVALID_OPEN_DATE));
                        return false;
                    }
                    sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_OPEN_DATE_SET.replace("date", worldData.getOpenDateString())));
                    worldData.saveTime();
                    return true;
                }
                case "auto-open": {
                    if (!sender.hasPermission("timeportals.manage.autoopen")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    if (args[2].isEmpty() || args[2].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_PROVIDE_BOOLEAN));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    String arg = args[2].toLowerCase();
                    if (!arg.equals("true") && !arg.equals("false")) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_PROVIDE_BOOLEAN));
                        return false;
                    }
                    boolean status = Boolean.parseBoolean(arg);
                    worldData.setAutomaticOpen(status);
                    if (status) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_AUTO_OPEN_ENABLED.replace("%world%", worldData.getWorld().getName())));
                    } else {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_AUTO_OPEN_DISABLED.replace("%world%", worldData.getWorld().getName())));
                    }
                    return true;
                }
                case "open-hour": {
                    if (!sender.hasPermission("timeportals.manage.openhour")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    if (args[2].isEmpty() || args[2].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_INDICATE_TIME));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    if (!worldData.setOpenTime(args[2])) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WRONG_TIME_FORMAT));
                        return false;
                    }
                    sender.sendMessage(Text.setColour(Settings.COMMAND_OPEN_TIME_CHANGED.replace("%time%", worldData.getOpenTime().toString())));
                    worldData.saveTime();
                    return true;
                }
                case "close-hour": {
                    if (!sender.hasPermission("timeportals.manage.closehour")) {
                        this.sendNoPermissions(sender);
                        return false;
                    }
                    if (args[1].isEmpty() || args[1].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_NO_WORLD_PROVIDED));
                        return false;
                    }
                    if (args[2].isEmpty() || args[2].isBlank()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_INDICATE_TIME));
                        return false;
                    }
                    Optional<WorldData> worldDataOptional = WorldsManager.getInstance().getWorldData(args[1]);
                    if (worldDataOptional.isEmpty()) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WORLD_NOT_FOUND.replace("%world%", args[1])));
                        return false;
                    }
                    WorldData worldData = worldDataOptional.get();
                    if (!worldData.setCloseTime(args[2])) {
                        sender.sendMessage(Text.setColour(Settings.COMMAND_WRONG_TIME_FORMAT));
                        return false;
                    }
                    sender.sendMessage(Text.setColour(Settings.COMMAND_CLOSE_TIME_CHANGED.replace("%time%", worldData.getCloseTime().toString())));
                    worldData.saveTime();
                    return true;
                }
            }
            this.sendUsage(sender);
            return true;
        }
        this.sendUsage(sender);
        return false;
    }

    private void sendNoPermissions(@NotNull CommandSender sender) {
    }

    private void sendUsage(CommandSender sender) {
        if (!sender.hasPermission("timeportals.use")) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(Text.setColour("&1&m---------------------&e&lTime&7&lPortals&1&m---------------------"));
        messages.add(Text.setColour("&8/&ftimeportals &blocaltime &8- &9Displays the current time of the server."));
        messages.add(Text.setColour("&8/&ftimeportals &bworlds &8- &9Displays all the worlds that are included."));
        messages.add(Text.setColour("&8/&ftimeportals &binfo &8<&3world&8> &8- &9Displays Information about a particular world."));
        messages.add(Text.setColour("&8/&ftimeportals &bignore &8<&3world&8> &8- &9It sets the given world to be disregarded."));
        messages.add(Text.setColour("&8/&ftimeportals &bopen &8<&3world&8> &8- &9It opens up the world."));
        messages.add(Text.setColour("&8/&ftimeportals &bclose &8<&3world&8> &8- &9It closes the world."));
        messages.add(Text.setColour("&8/&ftimeportals &bdisable &8<&3world&8> &8- &9Turns off the world completely"));
        messages.add(Text.setColour("&8/&ftimeportals &bopen-date &8<&3world&8> &8<&72024&8/&701&8/&722&8-&720&8:&700&8> &8- &9Sets the date from which the world will be active."));
        messages.add(Text.setColour("&8/&ftimeportals &bauto-open &8<&3world&8> &8<&2true&8|&cfalse&8> &8- &9Sets whether the world should be active at given times."));
        messages.add(Text.setColour("&8/&ftimeportals &bopen-hour &8<&3world&8> &8<&710&8:&700&8> &8- &9Sets from which time the world should be active."));
        messages.add(Text.setColour("&8/&ftimeportals &bclose-hour &8<&3world&8> &8<&710&8:&700&8> &8- &9Sets until what time the world should be active."));
        messages.add(Text.setColour("&8/&ftimeportals &breload &8- &9Reload the plugin."));
        messages.add(Text.setColour("&1&m---------------------&e&lTime&7&lPortals&1&m---------------------"));
        sender.sendMessage(messages.toArray(new String[0]));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (!sender.hasPermission("timeportals.tabcomplete")) {
            return list;
        }
        if (args.length == 1) {
            list.add("localtime");
            list.add("worlds");
            list.add("info");
            list.add("ignore");
            list.add("open");
            list.add("close");
            list.add("disable");
            list.add("open-date");
            list.add("auto-open");
            list.add("open-hour");
            list.add("close-hour");
            list.add("reload");
        } else if (args.length == 2) {
            if ("open".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("close".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("open-hour".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("close-hour".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("info".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("disable".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("open-date".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("auto-open".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
            if ("ignore".equals(args[0])) {
                list.addAll(WorldsManager.getInstance().getWorldsNames());
            }
        } else if (args.length == 3) {
            if ("open-date".equals(args[0])) {
                list.add(WorldsManager.DATE_TIME_FORMATTER.format(LocalDateTime.now()));
            }
            if ("auto-open".equals(args[0])) {
                list.add("true");
                list.add("false");
            }
            if ("open-hour".equals(args[0])) {
                list.add("10:00");
            }
            if ("close-hour".equals(args[0])) {
                list.add("12:00");
            }
        }
        String curArg = args[args.length - 1].toLowerCase();
        ArrayList<String> completer = new ArrayList<String>();
        for (String s : list) {
            if (!s.toLowerCase().startsWith(curArg)) continue;
            completer.add(s);
        }
        return completer;
    }
}

