/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.listeners;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import pl.ziomalu.timeportals.managers.WorldsManager;
import pl.ziomalu.timeportals.temp.TempPlayersManager;
import pl.ziomalu.timeportals.world.WorldData;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        TempPlayersManager.getInstance().removePlayer(e.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        Location location = player.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Optional<WorldData> optionalWorldData = WorldsManager.getInstance().getWorldData(world.getName());
        if (optionalWorldData.isEmpty()) {
            return;
        }
        WorldData worldData = optionalWorldData.get();
        if (worldData.getBypassPermission() != null && !worldData.getBypassPermission().isBlank() && player.hasPermission(worldData.getBypassPermission())) {
            return;
        }
        if (worldData.isOpen()) {
            return;
        }
        worldData.kickPlayerFromWorld(player);
    }
}

