/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.listeners;

import java.util.Optional;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import pl.ziomalu.timeportals.managers.WorldsManager;
import pl.ziomalu.timeportals.message.Message;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.temp.TempPlayer;
import pl.ziomalu.timeportals.temp.TempPlayersManager;
import pl.ziomalu.timeportals.utils.Time;
import pl.ziomalu.timeportals.utils.Utils;
import pl.ziomalu.timeportals.world.WorldData;

public class WorldChangeListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPortal(PlayerPortalEvent e) {
        if (e.getTo() == null) {
            return;
        }
        World targetWorld = e.getTo().getWorld();
        if (targetWorld == null) {
            return;
        }
        Player player = e.getPlayer();
        String targetWorldName = targetWorld.getName().toLowerCase();
        if ("world".equalsIgnoreCase(targetWorldName)) {
            TempPlayersManager.getInstance().removePlayer(player);
            return;
        }
        Optional<WorldData> optionalWorldData = WorldsManager.getInstance().getWorldData(targetWorldName);
        if (optionalWorldData.isEmpty()) {
            return;
        }
        WorldData worldData = optionalWorldData.get();
        if (worldData.getBypassPermission() != null && !worldData.getBypassPermission().isBlank() && player.hasPermission(worldData.getBypassPermission())) {
            return;
        }
        this.handleTeleport((PlayerTeleportEvent)e, worldData);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getTo() == null) {
            return;
        }
        World targetWorld = e.getTo().getWorld();
        if (targetWorld == null) {
            return;
        }
        Player player = e.getPlayer();
        String targetWorldName = targetWorld.getName().toLowerCase();
        if ("world".equalsIgnoreCase(targetWorldName)) {
            TempPlayersManager.getInstance().removePlayer(player);
            return;
        }
        if (e.getFrom() != null && e.getFrom().getWorld().equals(targetWorld)) {
            return;
        }
        Optional<WorldData> optionalWorldData = WorldsManager.getInstance().getWorldData(targetWorldName);
        if (optionalWorldData.isEmpty()) {
            return;
        }
        WorldData worldData = optionalWorldData.get();
        if (worldData.getBypassPermission() != null && !worldData.getBypassPermission().isBlank() && player.hasPermission(worldData.getBypassPermission())) {
            return;
        }
        this.handleTeleport(e, worldData);
    }

    private void handleTeleport(PlayerTeleportEvent e, WorldData worldData) {
        Player player = e.getPlayer();
        boolean forceClosed = worldData.isForceClosed();
        boolean isIgnored = worldData.isIgnored();
        boolean isOpen = worldData.isOpen();
        boolean isAfterDate = worldData.dateIsAfter();
        boolean automaticOpen = worldData.isAutomaticOpen();
        if ((forceClosed || isIgnored) && !isOpen) {
            String msg = Settings.WORLD_IS_DISABLED_MESSAGE.replace("%world%", Utils.fixWorldName(worldData.getWorld().getName()));
            Message.sendOnceMessage(player, msg);
            e.setCancelled(true);
            return;
        }
        if (!isOpen) {
            boolean timesEqual;
            if (!isAfterDate) {
                String msg = Settings.WORLD_FIRST_OPEN_MESSAGE.replace("%world%", Utils.fixWorldName(worldData.getWorld().getName())).replace("%date%", worldData.getOpenDateString());
                Message.sendOnceMessage(player, msg);
                e.setCancelled(true);
                return;
            }
            Time openTime = worldData.getOpenTime();
            Time closeTime = worldData.getCloseTime();
            boolean bl = timesEqual = openTime.getHour() == closeTime.getHour() && openTime.getMinutes() == closeTime.getMinutes() && openTime.getSeconds() == closeTime.getSeconds();
            if (forceClosed || timesEqual) {
                String msg = Settings.WORLD_IS_DISABLED_MESSAGE.replace("%world%", Utils.fixWorldName(worldData.getWorld().getName()));
                Message.sendOnceMessage(player, msg);
                e.setCancelled(true);
                return;
            }
            if (isAfterDate && automaticOpen) {
                String msg = Settings.WORLD_ACTIVE_HOURS_MESSAGE.replace("%world%", Utils.fixWorldName(worldData.getWorld().getName())).replace("%open-time%", openTime.toString()).replace("%close-time%", closeTime.toString());
                Message.sendOnceMessage(player, msg);
                e.setCancelled(true);
                return;
            }
        }
        TempPlayer tempPlayer = new TempPlayer(player.getUniqueId(), player.getName(), player.getLocation());
        TempPlayersManager.getInstance().addPlayer(tempPlayer);
        TempPlayersManager.getInstance().savePlayerLastLocAsync(tempPlayer);
    }
}

