/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import pl.ziomalu.api.config.ConfigValues;
import pl.ziomalu.timeportals.TimePortals;
import pl.ziomalu.timeportals.utils.BukkitConsole;

public final class Settings
extends ConfigValues {
    private static Settings instance;
    public static String WORLD_DISABLED_MESSAGE;
    public static String WORLD_ENABLED_MESSAGE;
    public static String WORLD_ACTIVE_HOURS_MESSAGE;
    public static String WORLD_FIRST_OPEN_MESSAGE;
    public static String WORLD_IS_DISABLED_MESSAGE;
    public static String PLUGIN_RELOADED_MESSAGE;
    public static String COMMAND_NO_PERMISSIONS;
    public static String COMMAND_LOCALTIME_MESSAGE;
    public static String COMMAND_WORLDS_HEADER;
    public static String COMMAND_WORLDS_WORLD_LINE;
    public static String COMMAND_WORLDS_WORLD_LINE_HOVER;
    public static String COMMAND_WORLDS_FOOTER;
    public static String COMMAND_NO_WORLD_PROVIDED;
    public static String COMMAND_WORLD_NOT_FOUND;
    public static String WORLDS_INFO_MENU_HEADER;
    public static String WORLDS_INFO_MENU_AUTOMATIC_OPEN;
    public static String WORLDS_INFO_MENU_IS_OPEN;
    public static String WORLDS_INFO_MENU_FORCE_CLOSED;
    public static String WORLDS_INFO_MENU_OPEN_DATE;
    public static String WORLDS_INFO_MENU_OPEN_TIME;
    public static String WORLDS_INFO_MENU_CLOSE_TIME;
    public static String WORLDS_INFO_MENU_IS_IGNORED;
    public static String WORLDS_INFO_MENU_BYPASS_PERMISSION;
    public static String WORLDS_INFO_MENU_FOOTER;
    public static String COMMAND_WORLD_ALREADY_OPEN;
    public static String COMMAND_WORLD_OPENED;
    public static String COMMAND_WORLD_ALREADY_CLOSED;
    public static String COMMAND_WORLD_CLOSED;
    public static String COMMAND_WORLD_DISABLED;
    public static String COMMAND_WORLD_ENABLED;
    public static String COMMAND_WORLD_INVALID_OPEN_DATE;
    public static String COMMAND_WORLD_OPEN_DATE_SET;
    public static String COMMAND_WRONG_TIME_FORMAT;
    public static String COMMAND_OPEN_TIME_CHANGED;
    public static String COMMAND_CLOSE_TIME_CHANGED;
    public static String COMMAND_INDICATE_TIME;
    public static String COMMAND_PROVIDE_BOOLEAN;
    public static String COMMAND_AUTO_OPEN_ENABLED;
    public static String COMMAND_AUTO_OPEN_DISABLED;
    public static boolean announceBeforeOpen;
    private static Map<Integer, String> announceOpenMessages;
    public static boolean announceBeforeClose;
    private static Map<Integer, String> announceCloseMessages;

    public Settings() {
        super(TimePortals.getInstance());
        instance = this;
    }

    public void load() {
        WORLD_DISABLED_MESSAGE = this.getAndSaveIfNotExists("world-disabled-message", WORLD_DISABLED_MESSAGE);
        WORLD_ENABLED_MESSAGE = this.getAndSaveIfNotExists("world-enabled-message", WORLD_ENABLED_MESSAGE);
        WORLD_ACTIVE_HOURS_MESSAGE = this.getAndSaveIfNotExists("world-active-hours-message", WORLD_ACTIVE_HOURS_MESSAGE);
        WORLD_FIRST_OPEN_MESSAGE = this.getAndSaveIfNotExists("world-first-open-message", WORLD_FIRST_OPEN_MESSAGE);
        WORLD_IS_DISABLED_MESSAGE = this.getAndSaveIfNotExists("world-is-disabled-message", WORLD_IS_DISABLED_MESSAGE);
        PLUGIN_RELOADED_MESSAGE = this.getAndSaveIfNotExists("plugin-reloaded-message", PLUGIN_RELOADED_MESSAGE);
        COMMAND_NO_PERMISSIONS = this.getAndSaveIfNotExists("command-no-permissions", COMMAND_NO_PERMISSIONS);
        COMMAND_LOCALTIME_MESSAGE = this.getAndSaveIfNotExists("command-localtime-message", COMMAND_LOCALTIME_MESSAGE);
        COMMAND_WORLDS_HEADER = this.getAndSaveIfNotExists("command-worlds.header", COMMAND_WORLDS_HEADER);
        COMMAND_WORLDS_WORLD_LINE = this.getAndSaveIfNotExists("command-worlds.world-line", COMMAND_WORLDS_WORLD_LINE);
        COMMAND_WORLDS_WORLD_LINE_HOVER = this.getAndSaveIfNotExists("command-worlds.world-line-hover", COMMAND_WORLDS_WORLD_LINE_HOVER);
        COMMAND_WORLDS_FOOTER = this.getAndSaveIfNotExists("command-worlds.footer", COMMAND_WORLDS_FOOTER);
        COMMAND_NO_WORLD_PROVIDED = this.getAndSaveIfNotExists("command-no-world-provided", COMMAND_NO_WORLD_PROVIDED);
        COMMAND_WORLD_NOT_FOUND = this.getAndSaveIfNotExists("command-world-not-found", COMMAND_WORLD_NOT_FOUND);
        WORLDS_INFO_MENU_HEADER = this.getAndSaveIfNotExists("worlds-info-menu.header", WORLDS_INFO_MENU_HEADER);
        WORLDS_INFO_MENU_AUTOMATIC_OPEN = this.getAndSaveIfNotExists("worlds-info-menu.automatic-open", WORLDS_INFO_MENU_AUTOMATIC_OPEN);
        WORLDS_INFO_MENU_IS_OPEN = this.getAndSaveIfNotExists("worlds-info-menu.is-open", WORLDS_INFO_MENU_IS_OPEN);
        WORLDS_INFO_MENU_FORCE_CLOSED = this.getAndSaveIfNotExists("worlds-info-menu.force-closed", WORLDS_INFO_MENU_FORCE_CLOSED);
        WORLDS_INFO_MENU_OPEN_DATE = this.getAndSaveIfNotExists("worlds-info-menu.open-date", WORLDS_INFO_MENU_OPEN_DATE);
        WORLDS_INFO_MENU_OPEN_TIME = this.getAndSaveIfNotExists("worlds-info-menu.open-time", WORLDS_INFO_MENU_OPEN_TIME);
        WORLDS_INFO_MENU_CLOSE_TIME = this.getAndSaveIfNotExists("worlds-info-menu.close-time", WORLDS_INFO_MENU_CLOSE_TIME);
        WORLDS_INFO_MENU_IS_IGNORED = this.getAndSaveIfNotExists("worlds-info-menu.is-ignored", WORLDS_INFO_MENU_IS_IGNORED);
        WORLDS_INFO_MENU_BYPASS_PERMISSION = this.getAndSaveIfNotExists("worlds-info-menu.bypass-permission", WORLDS_INFO_MENU_BYPASS_PERMISSION);
        WORLDS_INFO_MENU_FOOTER = this.getAndSaveIfNotExists("worlds-info-menu.footer", WORLDS_INFO_MENU_FOOTER);
        COMMAND_WORLD_ALREADY_OPEN = this.getAndSaveIfNotExists("command-world-already-open", COMMAND_WORLD_ALREADY_OPEN);
        COMMAND_WORLD_OPENED = this.getAndSaveIfNotExists("command-world-opened", COMMAND_WORLD_OPENED);
        COMMAND_WORLD_ALREADY_CLOSED = this.getAndSaveIfNotExists("command-world-already-closed", COMMAND_WORLD_ALREADY_CLOSED);
        COMMAND_WORLD_CLOSED = this.getAndSaveIfNotExists("command-world-closed", COMMAND_WORLD_CLOSED);
        COMMAND_WORLD_DISABLED = this.getAndSaveIfNotExists("command-world-disabled", COMMAND_WORLD_DISABLED);
        COMMAND_WORLD_ENABLED = this.getAndSaveIfNotExists("command-world-enabled", COMMAND_WORLD_ENABLED);
        COMMAND_WORLD_INVALID_OPEN_DATE = this.getStringAndSaveIfNotExists("command-world-invalid-open-date", COMMAND_WORLD_INVALID_OPEN_DATE, new String[0]);
        COMMAND_WORLD_OPEN_DATE_SET = this.getAndSaveIfNotExists("command-world-open-date-set", COMMAND_WORLD_OPEN_DATE_SET);
        COMMAND_WRONG_TIME_FORMAT = this.getStringAndSaveIfNotExists("command-wrong-time-format", COMMAND_WRONG_TIME_FORMAT, new String[0]);
        COMMAND_OPEN_TIME_CHANGED = this.getStringAndSaveIfNotExists("command-open-time-changed", COMMAND_OPEN_TIME_CHANGED, new String[0]);
        COMMAND_CLOSE_TIME_CHANGED = this.getStringAndSaveIfNotExists("command-close-time-changed", COMMAND_CLOSE_TIME_CHANGED, new String[0]);
        COMMAND_INDICATE_TIME = this.getStringAndSaveIfNotExists("command-indicate-time", COMMAND_INDICATE_TIME, new String[0]);
        COMMAND_PROVIDE_BOOLEAN = this.getStringAndSaveIfNotExists("command-provide-boolean", COMMAND_PROVIDE_BOOLEAN, new String[0]);
        COMMAND_AUTO_OPEN_ENABLED = this.getStringAndSaveIfNotExists("command-auto-open-enabled", COMMAND_AUTO_OPEN_ENABLED, new String[0]);
        COMMAND_AUTO_OPEN_DISABLED = this.getStringAndSaveIfNotExists("command-auto-open-disabled", COMMAND_AUTO_OPEN_DISABLED, new String[0]);
        announceBeforeOpen = this.getBooleanAndSaveIfNotExists("announce-before-open", false, new String[0]);
        announceBeforeClose = this.getBooleanAndSaveIfNotExists("announce-before-close", false, new String[0]);
        announceOpenMessages = this.loadMessagesMap("announce-open-messages");
        announceCloseMessages = this.loadMessagesMap("announce-close-messages");
        if (this.getMissingFields() == 0) {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eTimePortals\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Configuration loaded successfully. No missing fields detected.");
        } else {
            BukkitConsole.getInstance().sendMessage("\u00a78[\u00a7eTimePortals\u00a78]\u00a77 \u00a78[\u00a76Settings\u00a78] \u00a72Configuration loaded. \u00a7c" + this.getMissingFields() + " \u00a72missing fields have been added to the configuration.");
            this.save();
        }
    }

    private Map<Integer, String> loadMessagesMap(String path) {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        if (this.contains(path)) {
            for (String key : this.getConfig().getConfigurationSection(path).getKeys(false)) {
                String msg = this.getString(path + "." + key);
                try {
                    int sec = Integer.parseInt(key);
                    if (msg == null) continue;
                    map.put(sec, msg);
                }
                catch (NumberFormatException ignored) {
                    TimePortals.getInstance().getLogger().warning("Invalid key in config path '" + path + "': " + key + " is not a number");
                }
            }
        } else {
            if (path.equals("announce-open-messages")) {
                map.put(600, "&9World &f%world% &9opens in &c10 minutes!");
                map.put(300, "&9World &f%world% &9opens in &c5 minutes!");
                map.put(120, "&9World &f%world% &9opens in &c2 minutes!");
                map.put(60, "&9World &f%world% &9opens in &c1 minute!");
                map.put(10, "&9World &f%world% &9opens in &c10 seconds!");
                map.put(5, "&9World &f%world% &9opens in &c5 seconds!");
                map.put(1, "&9World &f%world% &9opens in &c1 second!");
            } else if (path.equals("announce-close-messages")) {
                map.put(600, "&9World &f%world% &9will close in &c10 minutes!");
                map.put(300, "&9World &f%world% &9will close in &c5 minutes!");
                map.put(120, "&9World &f%world% &9will close in &c2 minutes!");
                map.put(60, "&9World &f%world% &9will close in &c1 minute!");
                map.put(10, "&9World &f%world% &9will close in &c10 seconds!");
                map.put(5, "&9World &f%world% &9will close in &c5 seconds!");
                map.put(1, "&9World &f%world% &9will close in &c1 second!");
            }
            for (Map.Entry entry : map.entrySet()) {
                this.getConfig().set(path + "." + String.valueOf(entry.getKey()), entry.getValue());
            }
            this.save();
        }
        return map;
    }

    public static Settings getInstance() {
        return instance;
    }

    public static Map<Integer, String> getAnnounceOpenMessages() {
        return announceOpenMessages;
    }

    public static Map<Integer, String> getAnnounceCloseMessages() {
        return announceCloseMessages;
    }

    static {
        WORLD_DISABLED_MESSAGE = "&9The &f%world% &9has been turned &coff&9.";
        WORLD_ENABLED_MESSAGE = "&9The &f%world% &9has been turned &2on&9.";
        WORLD_ACTIVE_HOURS_MESSAGE = "&9The &f%world% &9is open between &f%open-time% &9and &f%close-time%&9.";
        WORLD_FIRST_OPEN_MESSAGE = "&9The &f%world% &9will open on &f%date%&9.";
        WORLD_IS_DISABLED_MESSAGE = "&9World &8: &f%world% &9is currently closed.";
        PLUGIN_RELOADED_MESSAGE = "&e&lTime&7&lPortals &6Plugin reloaded";
        COMMAND_NO_PERMISSIONS = "&4You do not have the permissions to use this command";
        COMMAND_LOCALTIME_MESSAGE = "&e&lTime&7&lPortals &6Current Time&8: &f%time%";
        COMMAND_WORLDS_HEADER = "&1&m----------------------&e&lWorlds&1&m----------------------";
        COMMAND_WORLDS_WORLD_LINE = "&9- &f%world%";
        COMMAND_WORLDS_WORLD_LINE_HOVER = "&6Click to view information about this world";
        COMMAND_WORLDS_FOOTER = "&1&m----------------------&e&lWorlds&1&m----------------------";
        COMMAND_NO_WORLD_PROVIDED = "&e&lTime&7&lPortals &cPlease provide a world name!";
        COMMAND_WORLD_NOT_FOUND = "&e&lTime&7&lPortals &cNo world found with name&8: &f%world%";
        WORLDS_INFO_MENU_HEADER = "&1&m------------------&e&l%world_name%&1&m------------------";
        WORLDS_INFO_MENU_AUTOMATIC_OPEN = "&9Automatic-Open&8: %automatic_open%";
        WORLDS_INFO_MENU_IS_OPEN = "&9IsOpen&8: %is_open%";
        WORLDS_INFO_MENU_FORCE_CLOSED = "&9Force-Closed&8: %force_closed%";
        WORLDS_INFO_MENU_OPEN_DATE = "&9Open-Date&8: &f%open_date%";
        WORLDS_INFO_MENU_OPEN_TIME = "&9Open-Time&8: &f%open_time%";
        WORLDS_INFO_MENU_CLOSE_TIME = "&9Close-Time&8: &f%close_time%";
        WORLDS_INFO_MENU_IS_IGNORED = "&9IsIgnored&8: %is_ignored%";
        WORLDS_INFO_MENU_BYPASS_PERMISSION = "&9Bypass Permission&8: &f%bypass_permission%";
        WORLDS_INFO_MENU_FOOTER = "&1&m------------------&e&l%world_name%&1&m------------------";
        COMMAND_WORLD_ALREADY_OPEN = "&e&lTime&7&lPortals &9World&8: &f%world% &9is already open";
        COMMAND_WORLD_OPENED = "&e&lTime&7&lPortals &9You opened up the world&9: &f%world%";
        COMMAND_WORLD_ALREADY_CLOSED = "&e&lTime&7&lPortals &9World&8: &f%world% &9is already closed";
        COMMAND_WORLD_CLOSED = "&e&lTime&7&lPortals &9You closed the world&9: &f%world%";
        COMMAND_WORLD_DISABLED = "&e&lTime&7&lPortals &9You disabled the world&9: &f%world%";
        COMMAND_WORLD_ENABLED = "&e&lTime&7&lPortals &9You enabled the world&9: &f%world%";
        COMMAND_WORLD_INVALID_OPEN_DATE = "&e&lTime&7&lPortals &9Please enter the time in the format&8: &f2024&8/&f01&8/&f28&8-&fhour&8:&fminutes&8:&fseconds";
        COMMAND_WORLD_OPEN_DATE_SET = "&e&lTime&7&lPortals &9The world will open up&8: &f%date%";
        COMMAND_WRONG_TIME_FORMAT = "&e&lTime&7&lPortals &9Please enter the time in the format&8: &fhour&8:&fminutes&8:&fseconds";
        COMMAND_OPEN_TIME_CHANGED = "&e&lTime&7&lPortals &9You have changed the time the world opens&9: &f%time%";
        COMMAND_CLOSE_TIME_CHANGED = "&e&lTime&7&lPortals &9You have changed the time the world closed&9: &f%time%";
        COMMAND_INDICATE_TIME = "&e&lTime&7&lPortals &cPlease indicate the time! &6e.g. &f10&8:&f00";
        COMMAND_PROVIDE_BOOLEAN = "&e&lTime&7&lPortals &fPlease provide &2true &8or &cfalse";
        COMMAND_AUTO_OPEN_ENABLED = "&e&lTime&7&lPortals &9You have enabled automatic opening for the world&8: &f%world%";
        COMMAND_AUTO_OPEN_DISABLED = "&e&lTime&7&lPortals &9You have disabled automatic opening for the world&8: &f%world%";
        announceBeforeOpen = true;
        announceOpenMessages = new LinkedHashMap<Integer, String>();
        announceBeforeClose = true;
        announceCloseMessages = new LinkedHashMap<Integer, String>();
    }
}

