/*
 * Decompiled with CFR 0.152.
 */
package pl.ziomalu.timeportals.tasks;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import pl.ziomalu.timeportals.message.Message;
import pl.ziomalu.timeportals.settings.Settings;
import pl.ziomalu.timeportals.utils.Time;
import pl.ziomalu.timeportals.utils.Utils;
import pl.ziomalu.timeportals.world.WorldData;

public class WorldsTask
implements Runnable {
    private List<WorldData> worlds;

    public WorldsTask(List<WorldData> worlds) {
        this.worlds = worlds;
    }

    public WorldsTask() {
        this.worlds = new ArrayList<WorldData>();
    }

    @Override
    public void run() {
        if (this.worlds == null || this.worlds.isEmpty()) {
            return;
        }
        LocalDateTime currentDateTime = LocalDateTime.now();
        LocalDate currentDate = currentDateTime.toLocalDate();
        for (WorldData world : this.worlds) {
            boolean isOpen;
            if (world.isIgnored()) {
                if (!world.isForceClosed() || !world.isOpen()) continue;
                world.close();
                continue;
            }
            if (!world.dateIsAfter()) {
                if (!world.isOpen()) continue;
                world.close();
                continue;
            }
            Time openTime = world.getOpenTime();
            Time closeTime = world.getCloseTime();
            if (world.isAutomaticOpen() && (openTime == null || closeTime == null || openTime.equals(closeTime))) continue;
            LocalDateTime openDateTime = LocalDateTime.of(currentDate, LocalTime.of(openTime.getHour(), openTime.getMinutes(), openTime.getSeconds()));
            LocalDateTime closeDateTime = LocalDateTime.of(currentDate, LocalTime.of(closeTime.getHour(), closeTime.getMinutes(), closeTime.getSeconds()));
            if (!currentDateTime.isBefore(closeDateTime)) {
                LocalDateTime nextOpenDateTime = openDateTime.plusDays(1L);
                world.setSecondsUntilOpen(Duration.between(currentDateTime, nextOpenDateTime).getSeconds());
                world.setSecondsUntilClose(-1L);
            } else if (currentDateTime.isBefore(openDateTime)) {
                world.setSecondsUntilOpen(Duration.between(currentDateTime, openDateTime).getSeconds());
                world.setSecondsUntilClose(Duration.between(currentDateTime, closeDateTime).getSeconds());
            } else {
                world.setSecondsUntilOpen(0L);
                world.setSecondsUntilClose(Duration.between(currentDateTime, closeDateTime).getSeconds());
            }
            int secondsUntilOpen = (int)world.getSecondsUntilOpen();
            if (Settings.announceBeforeOpen && Settings.getAnnounceOpenMessages().containsKey(secondsUntilOpen) && secondsUntilOpen != world.getLastOpenAnnouncement()) {
                String msg = Settings.getAnnounceOpenMessages().get(secondsUntilOpen).replace("%world%", Utils.fixWorldName(world.getWorld().getName()));
                Message.sendGlobalMessage(msg);
                world.setLastOpenAnnouncement(secondsUntilOpen);
            }
            int secondsUntilClose = (int)world.getSecondsUntilClose();
            if (Settings.announceBeforeClose && Settings.getAnnounceCloseMessages().containsKey(secondsUntilClose) && secondsUntilClose != world.getLastCloseAnnouncement()) {
                String msg = Settings.getAnnounceCloseMessages().get(secondsUntilClose).replace("%world%", Utils.fixWorldName(world.getWorld().getName()));
                Message.sendGlobalMessage(msg);
                world.setLastCloseAnnouncement(secondsUntilClose);
            }
            boolean bl = isOpen = world.dateIsAfter() && !world.isAutomaticOpen() || world.dateIsAfter() && world.isAutomaticOpen() && currentDateTime.isAfter(openDateTime) && currentDateTime.isBefore(closeDateTime);
            if (world.isOpen() == isOpen) continue;
            if (isOpen) {
                world.open();
                continue;
            }
            world.close();
        }
    }

    public void setWorlds(List<WorldData> worlds) {
        this.worlds = worlds;
    }
}

