/*
 * Decompiled with CFR 0.152.
 */
package com.github.command17.deliciouscake;

import com.github.command17.deliciouscake.block.ModBlocks;
import com.github.command17.deliciouscake.block.entity.ModBlockEntities;
import com.github.command17.deliciouscake.config.ModConfig;
import com.github.command17.deliciouscake.config.ModServerConfig;
import com.github.command17.deliciouscake.item.ModItems;
import com.github.command17.deliciouscake.item.tab.ModCreativeModeTabs;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredSupplier;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeliciousCake {
    public static final String MOD_ID = "deliciouscake";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"deliciouscake");
    public static final ModConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static final ModServerConfig SERVER_CONFIG;
    public static final ModConfigSpec SERVER_CONFIG_SPEC;

    public static void init() {
        LOGGER.info("Initializing...");
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeModeTabs.register();
        DeliciousCake.buildCreativeTabContent();
        LOGGER.info("Initialized.");
    }

    private static void buildCreativeTabContent() {
        DeferredSupplier foods = CreativeTabRegistry.defer((ResourceKey)CreativeModeTabs.FOOD_AND_DRINKS);
        if (((Boolean)DeliciousCake.CONFIG.showTab.get()).booleanValue()) {
            return;
        }
        CreativeTabRegistry.modify((DeferredSupplier)foods, (f, output, b) -> output.acceptAllAfter((ItemLike)Items.CAKE, (Collection)List.of(new ItemStack((ItemLike)ModItems.GLAZED_CAKE.get()), new ItemStack((ItemLike)ModItems.GOLDEN_APPLE_CAKE.get()), new ItemStack((ItemLike)ModItems.COOKIE_CAKE.get()), new ItemStack((ItemLike)ModItems.NETHER_CAKE.get())).reversed()));
        if (Platform.isFabric()) {
            DeferredSupplier search = CreativeTabRegistry.defer((ResourceKey)CreativeModeTabs.SEARCH);
            CreativeTabRegistry.modify((DeferredSupplier)search, (f, output, b) -> output.acceptAllAfter((ItemLike)Items.CAKE, (Collection)List.of(new ItemStack((ItemLike)ModItems.GLAZED_CAKE.get()), new ItemStack((ItemLike)ModItems.GOLDEN_APPLE_CAKE.get()), new ItemStack((ItemLike)ModItems.COOKIE_CAKE.get()), new ItemStack((ItemLike)ModItems.NETHER_CAKE.get())).reversed()));
        }
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static {
        Pair configPair = new ModConfigSpec.Builder().configure(ModConfig::new);
        CONFIG = (ModConfig)configPair.getKey();
        CONFIG_SPEC = (ModConfigSpec)configPair.getValue();
        Pair serverConfigPair = new ModConfigSpec.Builder().configure(ModServerConfig::new);
        SERVER_CONFIG = (ModServerConfig)serverConfigPair.getKey();
        SERVER_CONFIG_SPEC = (ModConfigSpec)serverConfigPair.getValue();
    }
}

