/*
 * Decompiled with CFR 0.152.
 */
package com.github.command17.deliciouscake.block;

import com.github.command17.deliciouscake.block.entity.CustomCakeBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomCakeBlock
extends BaseEntityBlock {
    public static final int MAX_BITES = 6;
    public static final MapCodec<CustomCakeBlock> CODEC = CustomCakeBlock.simpleCodec(CustomCakeBlock::new);
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final Vec3 PARTICLE_OFFSET = new Vec3(0.5, 1.0, 0.5);
    public static final VoxelShape CANDLE_SHAPE = Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    public static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public CustomCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean candleHit(BlockHitResult hit) {
        return hit.getLocation().y - (double)hit.getBlockPos().getY() > 0.5;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BITES, LIT});
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        CustomCakeBlockEntity blockEntity;
        VoxelShape shape = SHAPE_BY_BITE[(Integer)state.getValue((Property)BITES)];
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof CustomCakeBlockEntity && (blockEntity = (CustomCakeBlockEntity)blockEntity2).hasCandle()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CANDLE_SHAPE);
        }
        return shape;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomCakeBlockEntity) {
            Block block;
            CustomCakeBlockEntity blockEntity2 = (CustomCakeBlockEntity)blockEntity;
            if (blockEntity2.hasCandle()) {
                if (!stack.is(Items.FLINT_AND_STEEL) && !stack.is(Items.FIRE_CHARGE)) {
                    if (CustomCakeBlock.candleHit(hitResult) && stack.isEmpty() && blockEntity2.isLit()) {
                        blockEntity2.setLit(false);
                        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                    return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
                }
                if (stack.is(Items.FLINT_AND_STEEL) || stack.is(Items.FIRE_CHARGE) && !blockEntity2.isLit()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    if (stack.is(Items.FLINT_AND_STEEL)) {
                        level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    blockEntity2.setLit(true);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    player.awardStat(Stats.ITEM_USED.get((Object)item));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            if (stack.is(ItemTags.CANDLES) && (Integer)state.getValue((Property)BITES) == 0 && !blockEntity2.hasCandle() && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
                CandleBlock candleBlock = (CandleBlock)block;
                stack.consume(1, (LivingEntity)player);
                level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity2.setCandle(candleBlock);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.eat(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eat(level, pos, state, player);
    }

    protected InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(this.getFoodLevelModifier(), this.getSaturationLevelModifier());
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < 6) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CustomCakeBlockEntity) {
                CustomCakeBlockEntity blockEntity2 = (CustomCakeBlockEntity)blockEntity;
                blockEntity2.drop();
                state = blockEntity2.getLitState(false, state);
                blockEntity2.setCandle(null);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        this.onEat(state, level, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CustomCakeBlockEntity) {
            CustomCakeBlockEntity blockEntity2 = (CustomCakeBlockEntity)blockEntity;
            blockEntity2.drop();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        CustomCakeBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof CustomCakeBlockEntity && (blockEntity = (CustomCakeBlockEntity)blockEntity2).hasCandle() && blockEntity.isLit()) {
            this.addParticlesAndSound(level, PARTICLE_OFFSET.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), level.random);
        }
    }

    protected void addParticlesAndSound(Level level, Vec3 offset, RandomSource random) {
        float f = random.nextFloat();
        if (f < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.playLocalSound(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return CakeBlock.getOutputSignal((int)((Integer)state.getValue((Property)BITES)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public void onEat(BlockState state, Level level, BlockPos pos, Player player) {
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CustomCakeBlockEntity(pos, state);
    }

    public int getFoodLevelModifier() {
        return 2;
    }

    public float getSaturationLevelModifier() {
        return 0.1f;
    }
}

