/*
 * Decompiled with CFR 0.152.
 */
package com.github.command17.deliciouscake.block;

import com.github.command17.deliciouscake.DeliciousCake;
import com.github.command17.deliciouscake.block.CookieCakeBlock;
import com.github.command17.deliciouscake.block.CustomCakeBlock;
import com.github.command17.deliciouscake.block.EffectCakeBlock;
import com.github.command17.deliciouscake.block.NetherCakeBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public final class ModBlocks {
    private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"deliciouscake", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> GLAZED_CAKE = ModBlocks.registerSimpleCake("glazed_cake", ModBlocks.ofCake().mapColor(MapColor.COLOR_GREEN));
    public static final RegistrySupplier<Block> GOLDEN_APPLE_CAKE = ModBlocks.registerSimpleEffectCake("golden_apple_cake", () -> List.of(new MobEffectInstance(MobEffects.REGENERATION, ((Integer)DeliciousCake.SERVER_CONFIG.goldenAppleCakeRegenerationDuration.get()).intValue(), ((Integer)DeliciousCake.SERVER_CONFIG.goldenAppleCakeRegenerationAmplifier.get()).intValue()), new MobEffectInstance(MobEffects.ABSORPTION, ((Integer)DeliciousCake.SERVER_CONFIG.goldenAppleCakeAbsorptionDuration.get()).intValue(), ((Integer)DeliciousCake.SERVER_CONFIG.goldenAppleCakeAbsorptionAmplifier.get()).intValue())), ModBlocks.ofCake());
    public static final RegistrySupplier<Block> NETHER_CAKE = ModBlocks.register("nether_cake", () -> new NetherCakeBlock(ModBlocks.ofCake().mapColor(MapColor.COLOR_RED)));
    public static final RegistrySupplier<Block> COOKIE_CAKE = ModBlocks.register("cookie_cake", () -> new CookieCakeBlock(ModBlocks.ofCake().mapColor(MapColor.COLOR_BROWN)));

    private static RegistrySupplier<Block> registerSimpleEffectCake(String name, Supplier<List<MobEffectInstance>> effectFactory, BlockBehaviour.Properties properties) {
        return ModBlocks.register(name, () -> new EffectCakeBlock(effectFactory, properties));
    }

    private static RegistrySupplier<Block> registerSimpleCake(String name, BlockBehaviour.Properties properties) {
        return ModBlocks.register(name, () -> new CustomCakeBlock(properties));
    }

    private static RegistrySupplier<Block> register(String name, Supplier<Block> block) {
        return REGISTRY.register(name, block);
    }

    private static BlockBehaviour.Properties copyOf(Block block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }

    private static BlockBehaviour.Properties ofCake() {
        return ModBlocks.copyOf(Blocks.CAKE).lightLevel(state -> (Boolean)state.getValue((Property)CustomCakeBlock.LIT) != false ? 3 : 0);
    }

    public static void register() {
        REGISTRY.register();
        DeliciousCake.LOGGER.info("Registered Blocks.");
    }
}

