/*
 * Decompiled with CFR 0.152.
 */
package com.github.command17.deliciouscake.block.entity;

import com.github.command17.deliciouscake.block.CustomCakeBlock;
import com.github.command17.deliciouscake.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomCakeBlockEntity
extends BlockEntity {
    @Nullable
    private CandleBlock candle;

    public CustomCakeBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CUSTOM_CAKE.get(), pos, blockState);
    }

    public void drop() {
        if (this.hasCandle()) {
            ItemStack stack = new ItemStack((ItemLike)BlockItem.byBlock((Block)this.candle));
            Block.popResource((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (ItemStack)stack);
        }
    }

    public boolean hasCandle() {
        return this.candle != null;
    }

    @Nullable
    public CandleBlock getCandle() {
        return this.candle;
    }

    public boolean isLit() {
        return (Boolean)this.getBlockState().getValue((Property)CustomCakeBlock.LIT);
    }

    public void setCandle(@Nullable CandleBlock candle) {
        this.candle = candle;
    }

    public BlockState getLitState(boolean lit, BlockState state) {
        return (BlockState)state.setValue((Property)CustomCakeBlock.LIT, (Comparable)Boolean.valueOf(lit));
    }

    public void setLit(boolean lit) {
        this.level.setBlock(this.getBlockPos(), this.getLitState(lit, this.getBlockState()), 3);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Block candleBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("Candle")));
        if (candleBlock instanceof CandleBlock) {
            this.candle = (CandleBlock)candleBlock;
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveSyncedData(tag);
    }

    private void saveSyncedData(CompoundTag tag) {
        if (this.candle != null) {
            tag.putString("Candle", BuiltInRegistries.BLOCK.getKey((Object)this.candle).toString());
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveSyncedData(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

