/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.mixins;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import nl.devpieter.sees.Event.Event;
import nl.devpieter.sees.Sees;
import nl.devpieter.utilize.Utilize;
import nl.devpieter.utilize.events.interaction.AttackBlockEvent;
import nl.devpieter.utilize.events.interaction.AttackEntityEvent;
import nl.devpieter.utilize.events.interaction.BreakBlockEvent;
import nl.devpieter.utilize.events.interaction.InteractBlockEvent;
import nl.devpieter.utilize.events.interaction.InteractEntityEvent;
import nl.devpieter.utilize.events.interaction.InteractItemEvent;
import nl.devpieter.utilize.events.interaction.UpdateBlockBreakingProgressEvent;
import nl.devpieter.utilize.events.inventory.HotbarSlotChangedEvent;
import nl.devpieter.utilize.events.inventory.SlotClickEvent;
import nl.devpieter.utilize.utils.InventoryUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Unique
    private int lastSelectedHotbarSlot = -1;
    @Unique
    private final Sees sees = Sees.getInstance();

    @Shadow
    public abstract void method_2925();

    @Inject(at={@At(value="HEAD")}, method={"updateBlockBreakingProgress"}, cancellable=true)
    private void onUpdateBlockBreakingProgress(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (!this.sees.call((Event)new UpdateBlockBreakingProgressEvent(pos, direction))) {
            return;
        }
        this.method_2925();
        cir.setReturnValue((Object)false);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"breakBlock"}, cancellable=true)
    private void onBreakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (!this.sees.call((Event)new BreakBlockEvent(pos))) {
            return;
        }
        this.method_2925();
        cir.setReturnValue((Object)false);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"attackBlock"}, cancellable=true)
    private void onAttackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (!this.sees.call((Event)new AttackBlockEvent(pos, direction))) {
            return;
        }
        this.method_2925();
        cir.setReturnValue((Object)false);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"interactBlock"}, cancellable=true)
    private void onInteractBlock(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if (!this.sees.call((Event)new InteractBlockEvent(hand, hitResult))) {
            return;
        }
        cir.setReturnValue((Object)class_1269.field_5814);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"interactItem"}, cancellable=true)
    private void onInteractItem(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (!this.sees.call((Event)new InteractItemEvent(hand))) {
            return;
        }
        cir.setReturnValue((Object)class_1269.field_5814);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"attackEntity"}, cancellable=true)
    private void onAttackEntity(class_1657 player, class_1297 target, CallbackInfo ci) {
        System.out.println("AttackEntityEvent called for " + target.method_5477().getString() + " by " + player.method_5477().getString());
        if (!this.sees.call((Event)new AttackEntityEvent(target))) {
            return;
        }
        ci.cancel();
        Utilize.blockSwingHandOnce();
    }

    @Inject(at={@At(value="HEAD")}, method={"interactEntity"}, cancellable=true)
    private void onInteractEntity(class_1657 player, class_1297 target, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (!this.sees.call((Event)new InteractEntityEvent(target, hand))) {
            return;
        }
        cir.setReturnValue((Object)class_1269.field_5814);
        cir.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"clickSlot"}, cancellable=true)
    private void onClickSlot(int syncId, int slotId, int button, class_1713 actionType, class_1657 player, CallbackInfo ci) {
        if (!this.sees.call((Event)new SlotClickEvent(syncId, slotId, button, actionType))) {
            return;
        }
        ci.cancel();
    }

    @Inject(at={@At(value="TAIL")}, method={"syncSelectedSlot"})
    private void onSyncSelectedSlot(CallbackInfo ci) {
        int slot = InventoryUtils.getSelectedHotbarSlot();
        if (this.lastSelectedHotbarSlot == -1) {
            this.lastSelectedHotbarSlot = slot;
            return;
        }
        if (slot == this.lastSelectedHotbarSlot) {
            return;
        }
        this.lastSelectedHotbarSlot = slot;
        this.sees.call((Event)new HotbarSlotChangedEvent(this.lastSelectedHotbarSlot, slot));
    }
}

