/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import nl.devpieter.utilize.Utilize;
import org.jetbrains.annotations.NotNull;

public abstract class RequestHelper {
    public static final String USER_AGENT_HEADER = "User-Agent";
    protected static final HttpClient CLIENT = HttpClient.newHttpClient();

    @NotNull
    public static HttpResponse<String> simpleGet(@NotNull URI uri) throws IOException, InterruptedException {
        HttpRequest request = RequestHelper.createRequestBuilder(uri).GET().build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    @NotNull
    public static HttpResponse<String> simplePost(@NotNull URI uri, @NotNull HttpRequest.BodyPublisher bodyPublisher) throws IOException, InterruptedException {
        HttpRequest request = RequestHelper.createRequestBuilder(uri).POST(bodyPublisher).build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    @NotNull
    public static HttpResponse<String> simplePut(@NotNull URI uri, @NotNull HttpRequest.BodyPublisher bodyPublisher) throws IOException, InterruptedException {
        HttpRequest request = RequestHelper.createRequestBuilder(uri).PUT(bodyPublisher).build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    @NotNull
    public static HttpResponse<String> simpleDelete(@NotNull URI uri) throws IOException, InterruptedException {
        HttpRequest request = RequestHelper.createRequestBuilder(uri).DELETE().build();
        return CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public static HttpRequest.Builder createRequestBuilder(@NotNull URI uri) {
        String agent = String.format("Utilize/%s-%s", Utilize.getUtilizeVersion(), Utilize.getMinecraftVersion());
        return HttpRequest.newBuilder().header(USER_AGENT_HEADER, agent).header("Content-Type", "application/json").header("Accept", "application/json").uri(uri);
    }
}

