/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.managers;

import java.util.ArrayList;
import java.util.List;

public class TaskManager {
    private static TaskManager INSTANCE;
    private final List<ITask> tasks = new ArrayList<ITask>();

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TaskManager();
        }
        return INSTANCE;
    }

    public void addTask(ITask task) {
        this.tasks.add(task);
    }

    public void removeTask(ITask task) {
        this.tasks.remove(task);
    }

    public void tick() {
        for (ITask task : new ArrayList<ITask>(this.tasks)) {
            task.tick();
            if (!task.isFinished()) continue;
            this.removeTask(task);
        }
    }

    public static interface ITask {
        public void tick();

        public void reset();

        public boolean isFinished();
    }

    public static class RunOnceTask
    implements ITask {
        private final Runnable runnable;
        private final int startDelay;
        private boolean finished;
        private int tickCounter;

        public RunOnceTask(Runnable runnable, int startDelay) {
            this.runnable = runnable;
            this.startDelay = startDelay;
            this.tickCounter = 0;
        }

        @Override
        public void tick() {
            if (this.finished) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter < this.startDelay) {
                return;
            }
            this.runnable.run();
            this.finished = true;
        }

        @Override
        public void reset() {
            this.finished = false;
            this.tickCounter = 0;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }
}

