/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.setting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import nl.devpieter.utilize.Utilize;
import nl.devpieter.utilize.setting.KeyedSetting;
import nl.devpieter.utilize.setting.interfaces.ISetting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingManager {
    private static SettingManager INSTANCE;
    private final Gson gson = new Gson();
    private final Duration saveInterval = Duration.ofSeconds(15L);
    private final HashMap<String, List<KeyedSetting<?>>> saveQueue = new HashMap();
    private long lastSaveTime = 0L;
    private CompletableFuture<Boolean> saveFuture = null;

    private SettingManager() {
    }

    public static SettingManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SettingManager();
        }
        return INSTANCE;
    }

    public static void shutdown() {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.forceSaveQueue();
        INSTANCE = null;
    }

    public void tick() {
        if (this.saveQueue.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSaveTime < this.saveInterval.toMillis()) {
            return;
        }
        if (this.saveFuture != null && !this.saveFuture.isDone()) {
            return;
        }
        this.saveFuture = CompletableFuture.supplyAsync(() -> {
            int files = this.saveQueue.size();
            int size = this.saveQueue.values().stream().mapToInt(List::size).sum();
            Utilize.LOGGER.info("Starting periodic 'setting batch save' for {} files and {} settings", (Object)files, (Object)size);
            for (String path : this.saveQueue.keySet()) {
                File file = new File(path);
                if (this.saveBatchToFile(file, this.saveQueue.get(path))) continue;
                Utilize.LOGGER.error("Failed to save settings batch to file: {}", (Object)file.getAbsolutePath());
            }
            this.lastSaveTime = currentTime;
            this.saveQueue.clear();
            return true;
        });
    }

    public boolean queueSave(@NotNull File file, @NotNull ISetting<?> setting) {
        String path = file.getAbsolutePath();
        KeyedSetting<?> keyedSetting = setting.asKeyedSetting();
        List settingsList = this.saveQueue.getOrDefault(path, new ArrayList());
        settingsList.removeIf(s -> s.key().equals(keyedSetting.key()));
        settingsList.add(keyedSetting);
        this.saveQueue.put(path, settingsList);
        return true;
    }

    public boolean queueSave(@NotNull File file, @NotNull List<ISetting<?>> settings) {
        boolean success = true;
        for (ISetting<?> setting : settings) {
            if (this.queueSave(file, setting)) continue;
            success = false;
        }
        return success;
    }

    public void forceSaveQueue() {
        if (this.saveQueue.isEmpty()) {
            return;
        }
        int files = this.saveQueue.size();
        int size = this.saveQueue.values().stream().mapToInt(List::size).sum();
        Utilize.LOGGER.info("Forced starting 'setting batch save' for {} files and {} settings", (Object)files, (Object)size);
        for (String path : this.saveQueue.keySet()) {
            File file = new File(path);
            if (this.saveBatchToFile(file, this.saveQueue.get(path))) continue;
            Utilize.LOGGER.error("Failed to force save settings batch to file: {}", (Object)file.getAbsolutePath());
        }
        this.saveQueue.clear();
    }

    public <T> boolean loadSetting(@NotNull File file, @NotNull ISetting<T> setting) {
        List<KeyedSetting<?>> batch = this.readBatchFromFile(file);
        return this.loadSettingFromBatch(setting, batch);
    }

    public boolean loadSettings(@NotNull File file, @NotNull List<ISetting<?>> settings) {
        List<KeyedSetting<?>> batch = this.readBatchFromFile(file);
        for (ISetting<?> setting : settings) {
            this.loadSettingFromBatch(setting, batch);
        }
        return true;
    }

    private <T> boolean loadSettingFromBatch(@NotNull ISetting<T> setting, @Nullable List<KeyedSetting<?>> batch) {
        if (batch == null || batch.isEmpty()) {
            setting.setValue(setting.getDefault());
            return true;
        }
        for (KeyedSetting<?> keyedSetting : batch) {
            if (!keyedSetting.key().equals(setting.getIdentifier())) continue;
            JsonElement jsonElement = this.gson.toJsonTree(keyedSetting.value());
            Object value = this.gson.fromJson(jsonElement, setting.getType());
            setting.setValue(setting.shouldAllowNull() ? value : (value != null ? value : setting.getDefault()));
            return true;
        }
        Utilize.LOGGER.warn("Failed to load setting: {} from batch", (Object)setting.getIdentifier());
        return false;
    }

    private boolean saveBatchToFile(@NotNull File file, @NotNull List<KeyedSetting<?>> settings) {
        boolean bl;
        List<KeyedSetting<?>> currentSettings = this.readBatchFromFile(file);
        if (currentSettings == null) {
            currentSettings = new ArrayList();
        }
        HashMap settingsMap = new HashMap();
        for (KeyedSetting<?> setting : currentSettings) {
            settingsMap.put(setting.key(), setting);
        }
        for (KeyedSetting<?> setting : settings) {
            settingsMap.put(setting.key(), setting);
        }
        currentSettings = new ArrayList(settingsMap.values());
        FileWriter writer = new FileWriter(file);
        try {
            this.gson.toJson(currentSettings, (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Utilize.LOGGER.error("Failed to save settings batch to file: {}", (Object)file.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    @Nullable
    private List<KeyedSetting<?>> readBatchFromFile(@NotNull File file) {
        List list;
        FileReader reader = new FileReader(file);
        try {
            list = (List)this.gson.fromJson((Reader)reader, new TypeToken<List<KeyedSetting<?>>>(this){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Utilize.LOGGER.error("Failed to read settings batch from file: {}", (Object)file.getAbsolutePath(), (Object)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return list;
    }
}

