/*
 * Decompiled with CFR 0.152.
 */
package nl.devpieter.utilize.setting.settings;

import java.lang.reflect.Type;
import nl.devpieter.utilize.setting.base.SettingBase;
import nl.devpieter.utilize.setting.interfaces.INumberSetting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatSetting
extends SettingBase<Float>
implements INumberSetting<Float> {
    public FloatSetting(@NotNull String identifier, Float defaultValue) {
        super(identifier, defaultValue);
    }

    public FloatSetting(@NotNull String identifier, Float defaultValue, boolean allowNull) {
        super(identifier, defaultValue, allowNull);
    }

    @Override
    public void increment() {
        if (this.getValue() == null) {
            throw new IllegalStateException("Cannot increment a null value. Use setValue() instead.");
        }
        this.setValue(Float.valueOf(((Float)this.getValue()).floatValue() + 1.0f));
    }

    @Override
    public void increment(@Nullable Float amount) {
        if (amount == null && !this.shouldAllowNull()) {
            throw new IllegalArgumentException("Amount cannot be null");
        }
        if (amount == null) {
            this.setValue(Float.valueOf(0.0f));
        } else if (this.getValue() == null) {
            this.setValue(amount);
        } else {
            this.setValue(Float.valueOf(((Float)this.getValue()).floatValue() + amount.floatValue()));
        }
    }

    @Override
    public void decrement() {
        if (this.getValue() == null) {
            throw new IllegalStateException("Cannot decrement a null value. Use setValue() instead.");
        }
        this.setValue(Float.valueOf(((Float)this.getValue()).floatValue() - 1.0f));
    }

    @Override
    public void decrement(@Nullable Float amount) {
        if (amount == null && !this.shouldAllowNull()) {
            throw new IllegalArgumentException("Amount cannot be null");
        }
        if (amount == null) {
            this.setValue(Float.valueOf(0.0f));
        } else if (this.getValue() == null) {
            this.setValue(Float.valueOf(-amount.floatValue()));
        } else {
            this.setValue(Float.valueOf(((Float)this.getValue()).floatValue() - amount.floatValue()));
        }
    }

    @Override
    public Type getType() {
        return Float.class;
    }
}

